/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.config;

import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;

public class ConnectionConfig$Builder {
    private int bufferSize;
    private int fragmentSizeHint = -1;
    private Charset charset;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableInputAction;
    private MessageConstraints messageConstraints;

    ConnectionConfig$Builder() {
    }

    public ConnectionConfig$Builder setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public ConnectionConfig$Builder setFragmentSizeHint(int fragmentSizeHint) {
        this.fragmentSizeHint = fragmentSizeHint;
        return this;
    }

    public ConnectionConfig$Builder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public ConnectionConfig$Builder setMalformedInputAction(CodingErrorAction malformedInputAction) {
        this.malformedInputAction = malformedInputAction;
        if (malformedInputAction != null && this.charset == null) {
            this.charset = Consts.ASCII;
        }
        return this;
    }

    public ConnectionConfig$Builder setUnmappableInputAction(CodingErrorAction unmappableInputAction) {
        this.unmappableInputAction = unmappableInputAction;
        if (unmappableInputAction != null && this.charset == null) {
            this.charset = Consts.ASCII;
        }
        return this;
    }

    public ConnectionConfig$Builder setMessageConstraints(MessageConstraints messageConstraints) {
        this.messageConstraints = messageConstraints;
        return this;
    }

    public ConnectionConfig build() {
        Charset cs2 = this.charset;
        if (cs2 == null && (this.malformedInputAction != null || this.unmappableInputAction != null)) {
            cs2 = Consts.ASCII;
        }
        int bufSize = this.bufferSize > 0 ? this.bufferSize : 8192;
        int fragmentHintSize = this.fragmentSizeHint >= 0 ? this.fragmentSizeHint : bufSize;
        return new ConnectionConfig(bufSize, fragmentHintSize, cs2, this.malformedInputAction, this.unmappableInputAction, this.messageConstraints);
    }
}

