/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.Rule$Phoneme;
import org.apache.commons.codec.language.bm.Rule$PhonemeExpr;

final class PhoneticEngine$PhonemeBuilder {
    private final Set<Rule$Phoneme> phonemes;

    public static PhoneticEngine$PhonemeBuilder empty(Languages$LanguageSet languages) {
        return new PhoneticEngine$PhonemeBuilder(new Rule$Phoneme("", languages));
    }

    private PhoneticEngine$PhonemeBuilder(Rule$Phoneme phoneme) {
        this.phonemes = new LinkedHashSet<Rule$Phoneme>();
        this.phonemes.add(phoneme);
    }

    private PhoneticEngine$PhonemeBuilder(Set<Rule$Phoneme> phonemes) {
        this.phonemes = phonemes;
    }

    public void append(CharSequence str) {
        for (Rule$Phoneme ph2 : this.phonemes) {
            ph2.append(str);
        }
    }

    public void apply(Rule$PhonemeExpr phonemeExpr, int maxPhonemes) {
        LinkedHashSet<Rule$Phoneme> newPhonemes = new LinkedHashSet<Rule$Phoneme>(maxPhonemes);
        block0: for (Rule$Phoneme left : this.phonemes) {
            for (Rule$Phoneme right : phonemeExpr.getPhonemes()) {
                Languages$LanguageSet languages = left.getLanguages().restrictTo(right.getLanguages());
                if (languages.isEmpty()) continue;
                Rule$Phoneme join = new Rule$Phoneme(left, right, languages);
                if (newPhonemes.size() >= maxPhonemes) continue;
                newPhonemes.add(join);
                if (newPhonemes.size() < maxPhonemes) continue;
                break block0;
            }
        }
        this.phonemes.clear();
        this.phonemes.addAll(newPhonemes);
    }

    public Set<Rule$Phoneme> getPhonemes() {
        return this.phonemes;
    }

    public String makeString() {
        StringBuilder sb2 = new StringBuilder();
        for (Rule$Phoneme ph2 : this.phonemes) {
            if (sb2.length() > 0) {
                sb2.append("|");
            }
            sb2.append(ph2.getPhonemeText());
        }
        return sb2.toString();
    }
}

