/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.codec.language.bm.Lang$LangRule;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;

public class Lang {
    private static final Map<NameType, Lang> Langs = new EnumMap<NameType, Lang>(NameType.class);
    private static final String LANGUAGE_RULES_RN = "org/apache/commons/codec/language/bm/lang.txt";
    private final Languages languages;
    private final List<Lang$LangRule> rules;

    public static Lang instance(NameType nameType) {
        return Langs.get((Object)nameType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lang loadFromResource(String languageRulesResourceName, Languages languages) {
        ArrayList<Lang$LangRule> rules = new ArrayList<Lang$LangRule>();
        InputStream lRulesIS = Lang.class.getClassLoader().getResourceAsStream(languageRulesResourceName);
        if (lRulesIS == null) {
            throw new IllegalStateException("Unable to resolve required resource:org/apache/commons/codec/language/bm/lang.txt");
        }
        try (Scanner scanner = new Scanner(lRulesIS, "UTF-8");){
            boolean inExtendedComment = false;
            while (scanner.hasNextLine()) {
                String rawLine;
                String line = rawLine = scanner.nextLine();
                if (inExtendedComment) {
                    if (!line.endsWith("*/")) continue;
                    inExtendedComment = false;
                    continue;
                }
                if (line.startsWith("/*")) {
                    inExtendedComment = true;
                    continue;
                }
                int cmtI = line.indexOf("//");
                if (cmtI >= 0) {
                    line = line.substring(0, cmtI);
                }
                if ((line = line.trim()).length() == 0) continue;
                String[] parts = line.split("\\s+");
                if (parts.length != 3) {
                    throw new IllegalArgumentException("Malformed line '" + rawLine + "' in language resource '" + languageRulesResourceName + "'");
                }
                Pattern pattern = Pattern.compile(parts[0]);
                String[] langs = parts[1].split("\\+");
                boolean accept = parts[2].equals("true");
                rules.add(new Lang$LangRule(pattern, new HashSet<String>(Arrays.asList(langs)), accept));
            }
        }
        return new Lang(rules, languages);
    }

    private Lang(List<Lang$LangRule> rules, Languages languages) {
        this.rules = Collections.unmodifiableList(rules);
        this.languages = languages;
    }

    public String guessLanguage(String text) {
        Languages$LanguageSet ls2 = this.guessLanguages(text);
        return ls2.isSingleton() ? ls2.getAny() : "any";
    }

    public Languages$LanguageSet guessLanguages(String input) {
        String text = input.toLowerCase(Locale.ENGLISH);
        HashSet<String> langs = new HashSet<String>(this.languages.getLanguages());
        for (Lang$LangRule rule : this.rules) {
            if (!rule.matches(text)) continue;
            if (Lang$LangRule.access$100(rule)) {
                langs.retainAll(Lang$LangRule.access$200(rule));
                continue;
            }
            langs.removeAll(Lang$LangRule.access$200(rule));
        }
        Languages$LanguageSet ls2 = Languages$LanguageSet.from(langs);
        return ls2.equals(Languages.NO_LANGUAGES) ? Languages.ANY_LANGUAGE : ls2;
    }

    static {
        for (NameType s2 : NameType.values()) {
            Langs.put(s2, Lang.loadFromResource(LANGUAGE_RULES_RN, Languages.getInstance(s2)));
        }
    }
}

