/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.ListCompositeDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.EndConsumerHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ResourceSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    private final AtomicReference<Yy> s = new AtomicReference();
    private final ListCompositeDisposable resources = new ListCompositeDisposable();
    private final AtomicLong missedRequested = new AtomicLong();

    public final void add(Disposable resource) {
        ObjectHelper.requireNonNull(resource, "resource is null");
        this.resources.add(resource);
    }

    @Override
    public final void onSubscribe(Yy s2) {
        if (EndConsumerHelper.setOnce(this.s, s2, this.getClass())) {
            long r2 = this.missedRequested.getAndSet(0L);
            if (r2 != 0L) {
                s2.request(r2);
            }
            this.onStart();
        }
    }

    protected void onStart() {
        this.request(Long.MAX_VALUE);
    }

    protected final void request(long n2) {
        SubscriptionHelper.deferredRequest(this.s, this.missedRequested, n2);
    }

    @Override
    public final void dispose() {
        if (SubscriptionHelper.cancel(this.s)) {
            this.resources.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return SubscriptionHelper.isCancelled(this.s.get());
    }
}

