/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.SingleSubject$SingleDisposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleSubject<T>
extends Single<T>
implements SingleObserver<T> {
    final AtomicReference<SingleSubject$SingleDisposable<T>[]> observers;
    static final SingleSubject$SingleDisposable[] EMPTY = new SingleSubject$SingleDisposable[0];
    static final SingleSubject$SingleDisposable[] TERMINATED = new SingleSubject$SingleDisposable[0];
    final AtomicBoolean once = new AtomicBoolean();
    T value;
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> SingleSubject<T> create() {
        return new SingleSubject<T>();
    }

    SingleSubject() {
        this.observers = new AtomicReference<SingleSubject$SingleDisposable[]>(EMPTY);
    }

    @Override
    public void onSubscribe(@NonNull Disposable d2) {
        if (this.observers.get() == TERMINATED) {
            d2.dispose();
        }
    }

    @Override
    public void onSuccess(@NonNull T value) {
        ObjectHelper.requireNonNull(value, "onSuccess called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.once.compareAndSet(false, true)) {
            this.value = value;
            for (SingleSubject$SingleDisposable md2 : this.observers.getAndSet(TERMINATED)) {
                md2.actual.onSuccess(value);
            }
        }
    }

    @Override
    public void onError(@NonNull Throwable e2) {
        ObjectHelper.requireNonNull(e2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.once.compareAndSet(false, true)) {
            this.error = e2;
            for (SingleSubject$SingleDisposable md2 : this.observers.getAndSet(TERMINATED)) {
                md2.actual.onError(e2);
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void subscribeActual(@NonNull SingleObserver<? super T> observer) {
        SingleSubject$SingleDisposable<T> md2 = new SingleSubject$SingleDisposable<T>(observer, this);
        observer.onSubscribe(md2);
        if (this.add(md2)) {
            if (md2.isDisposed()) {
                this.remove(md2);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                observer.onError(ex2);
            } else {
                observer.onSuccess(this.value);
            }
        }
    }

    boolean add(@NonNull SingleSubject$SingleDisposable<T> inner) {
        SingleSubject$SingleDisposable[] b2;
        SingleSubject$SingleDisposable<T>[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new SingleSubject$SingleDisposable[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = inner;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    void remove(@NonNull SingleSubject$SingleDisposable<T> inner) {
        SingleSubject$SingleDisposable[] b2;
        SingleSubject$SingleDisposable<T>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != inner) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new SingleSubject$SingleDisposable[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }

    @Nullable
    public T getValue() {
        if (this.observers.get() == TERMINATED) {
            return this.value;
        }
        return null;
    }

    public boolean hasValue() {
        return this.observers.get() == TERMINATED && this.value != null;
    }

    @Nullable
    public Throwable getThrowable() {
        if (this.observers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    public boolean hasThrowable() {
        return this.observers.get() == TERMINATED && this.error != null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }
}

