/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList$NonThrowingPredicate;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;

final class SerializedSubject<T>
extends Subject<T>
implements AppendOnlyLinkedArrayList$NonThrowingPredicate<Object> {
    final Subject<T> actual;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    SerializedSubject(Subject<T> actual) {
        this.actual = actual;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        this.actual.subscribe(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Disposable s2) {
        boolean cancel;
        if (!this.done) {
            SerializedSubject serializedSubject = this;
            synchronized (serializedSubject) {
                if (this.done) {
                    cancel = true;
                } else {
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                        if (q2 == null) {
                            this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                        }
                        q2.add(NotificationLite.disposable(s2));
                        return;
                    }
                    this.emitting = true;
                    cancel = false;
                }
            }
        } else {
            cancel = true;
        }
        if (cancel) {
            s2.dispose();
        } else {
            this.actual.onSubscribe(s2);
            this.emitLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                if (q2 == null) {
                    this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                }
                q2.add(NotificationLite.next(t2));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t2);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                reportError = true;
            } else {
                this.done = true;
                if (this.emitting) {
                    AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                    if (q2 == null) {
                        this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                    }
                    q2.setFirst(NotificationLite.error(t2));
                    return;
                }
                reportError = false;
                this.emitting = true;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                if (q2 == null) {
                    this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                }
                q2.add(NotificationLite.complete());
                return;
            }
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        while (true) {
            AppendOnlyLinkedArrayList<Object> q2;
            SerializedSubject serializedSubject = this;
            synchronized (serializedSubject) {
                q2 = this.queue;
                if (q2 == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            q2.forEachWhile(this);
        }
    }

    @Override
    public boolean test(Object o2) {
        return NotificationLite.acceptFull(o2, this.actual);
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }

    @Override
    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    @Override
    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    @Override
    public boolean hasComplete() {
        return this.actual.hasComplete();
    }
}

