/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.ReplaySubject$ReplayBuffer;
import io.reactivex.subjects.ReplaySubject$ReplayDisposable;
import io.reactivex.subjects.ReplaySubject$SizeAndTimeBoundReplayBuffer;
import io.reactivex.subjects.ReplaySubject$SizeBoundReplayBuffer;
import io.reactivex.subjects.ReplaySubject$UnboundedReplayBuffer;
import io.reactivex.subjects.Subject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplaySubject<T>
extends Subject<T> {
    final ReplaySubject$ReplayBuffer<T> buffer;
    final AtomicReference<ReplaySubject$ReplayDisposable<T>[]> observers;
    static final ReplaySubject$ReplayDisposable[] EMPTY = new ReplaySubject$ReplayDisposable[0];
    static final ReplaySubject$ReplayDisposable[] TERMINATED = new ReplaySubject$ReplayDisposable[0];
    boolean done;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @CheckReturnValue
    public static <T> ReplaySubject<T> create() {
        return new ReplaySubject(new ReplaySubject$UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    public static <T> ReplaySubject<T> create(int capacityHint) {
        return new ReplaySubject(new ReplaySubject$UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    public static <T> ReplaySubject<T> createWithSize(int maxSize) {
        return new ReplaySubject(new ReplaySubject$SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplaySubject<T> createUnbounded() {
        return new ReplaySubject(new ReplaySubject$SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    public static <T> ReplaySubject<T> createWithTime(long maxAge, TimeUnit unit, Scheduler scheduler) {
        return new ReplaySubject(new ReplaySubject$SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    public static <T> ReplaySubject<T> createWithTimeAndSize(long maxAge, TimeUnit unit, Scheduler scheduler, int maxSize) {
        return new ReplaySubject(new ReplaySubject$SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplaySubject(ReplaySubject$ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.observers = new AtomicReference<ReplaySubject$ReplayDisposable[]>(EMPTY);
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        ReplaySubject$ReplayDisposable<? super T> rs2 = new ReplaySubject$ReplayDisposable<T>(observer, this);
        observer.onSubscribe(rs2);
        if (!rs2.cancelled) {
            if (this.add(rs2) && rs2.cancelled) {
                this.remove(rs2);
                return;
            }
            this.buffer.replay(rs2);
        }
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (this.done) {
            s2.dispose();
        }
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            return;
        }
        ReplaySubject$ReplayBuffer<T> b2 = this.buffer;
        b2.add(t2);
        for (ReplaySubject$ReplayDisposable<T> rs2 : this.observers.get()) {
            b2.replay(rs2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        Object o2 = NotificationLite.error(t2);
        ReplaySubject$ReplayBuffer<T> b2 = this.buffer;
        b2.addFinal(o2);
        for (ReplaySubject$ReplayDisposable<T> rs2 : this.terminate(o2)) {
            b2.replay(rs2);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object o2 = NotificationLite.complete();
        ReplaySubject$ReplayBuffer<T> b2 = this.buffer;
        b2.addFinal(o2);
        for (ReplaySubject$ReplayDisposable<T> rs2 : this.terminate(o2)) {
            b2.replay(rs2);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        Object o2 = this.buffer.get();
        if (NotificationLite.isError(o2)) {
            return NotificationLite.getError(o2);
        }
        return null;
    }

    public T getValue() {
        return this.buffer.getValue();
    }

    public Object[] getValues() {
        Object[] a2 = EMPTY_ARRAY;
        Object[] b2 = this.getValues(a2);
        if (b2 == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b2;
    }

    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    public boolean hasComplete() {
        Object o2 = this.buffer.get();
        return NotificationLite.isComplete(o2);
    }

    @Override
    public boolean hasThrowable() {
        Object o2 = this.buffer.get();
        return NotificationLite.isError(o2);
    }

    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    int size() {
        return this.buffer.size();
    }

    boolean add(ReplaySubject$ReplayDisposable<T> rs2) {
        ReplaySubject$ReplayDisposable[] b2;
        ReplaySubject$ReplayDisposable<T>[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int len = a2.length;
            b2 = new ReplaySubject$ReplayDisposable[len + 1];
            System.arraycopy(a2, 0, b2, 0, len);
            b2[len] = rs2;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    void remove(ReplaySubject$ReplayDisposable<T> rs2) {
        ReplaySubject$ReplayDisposable[] b2;
        ReplaySubject$ReplayDisposable<T>[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED || a2 == EMPTY) {
                return;
            }
            int len = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (a2[i2] != rs2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new ReplaySubject$ReplayDisposable[len - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, len - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }

    ReplaySubject$ReplayDisposable<T>[] terminate(Object terminalValue) {
        if (this.buffer.compareAndSet(null, terminalValue)) {
            return this.observers.getAndSet(TERMINATED);
        }
        return TERMINATED;
    }
}

