/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.subjects.ReplaySubject$ReplayBuffer;
import io.reactivex.subjects.ReplaySubject$ReplayDisposable;
import io.reactivex.subjects.ReplaySubject$TimedNode;
import java.lang.reflect.Array;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ReplaySubject$SizeAndTimeBoundReplayBuffer<T>
extends AtomicReference<Object>
implements ReplaySubject$ReplayBuffer<T> {
    private static final long serialVersionUID = -8056260896137901749L;
    final int maxSize;
    final long maxAge;
    final TimeUnit unit;
    final Scheduler scheduler;
    int size;
    volatile ReplaySubject$TimedNode<Object> head;
    ReplaySubject$TimedNode<Object> tail;
    volatile boolean done;

    ReplaySubject$SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
        this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
        this.maxAge = ObjectHelper.verifyPositive(maxAge, "maxAge");
        this.unit = ObjectHelper.requireNonNull(unit, "unit is null");
        this.scheduler = ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ReplaySubject$TimedNode<Object> h2 = new ReplaySubject$TimedNode<Object>(null, 0L);
        this.tail = h2;
        this.head = h2;
    }

    void trim() {
        if (this.size > this.maxSize) {
            --this.size;
            ReplaySubject$TimedNode<Object> h2 = this.head;
            this.head = (ReplaySubject$TimedNode)h2.get();
        }
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        ReplaySubject$TimedNode h3 = this.head;
        while (true) {
            ReplaySubject$TimedNode next;
            if ((next = (ReplaySubject$TimedNode)h3.get()) == null) {
                this.head = h3;
                break;
            }
            if (next.time > limit) {
                this.head = h3;
                break;
            }
            h3 = next;
        }
    }

    void trimFinal() {
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        ReplaySubject$TimedNode h2 = this.head;
        while (true) {
            ReplaySubject$TimedNode next;
            if ((next = (ReplaySubject$TimedNode)h2.get()).get() == null) {
                this.head = h2;
                break;
            }
            if (next.time > limit) {
                this.head = h2;
                break;
            }
            h2 = next;
        }
    }

    @Override
    public void add(T value) {
        ReplaySubject$TimedNode<T> n2 = new ReplaySubject$TimedNode<T>(value, this.scheduler.now(this.unit));
        ReplaySubject$TimedNode<Object> t2 = this.tail;
        this.tail = n2;
        ++this.size;
        t2.set(n2);
        this.trim();
    }

    @Override
    public void addFinal(Object notificationLite) {
        ReplaySubject$TimedNode<Object> n2 = new ReplaySubject$TimedNode<Object>(notificationLite, Long.MAX_VALUE);
        ReplaySubject$TimedNode<Object> t2 = this.tail;
        this.tail = n2;
        ++this.size;
        t2.lazySet(n2);
        this.trimFinal();
        this.done = true;
    }

    @Override
    public T getValue() {
        ReplaySubject$TimedNode next;
        ReplaySubject$TimedNode prev = null;
        ReplaySubject$TimedNode h2 = this.head;
        while ((next = (ReplaySubject$TimedNode)h2.get()) != null) {
            prev = h2;
            h2 = next;
        }
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        if (h2.time < limit) {
            return null;
        }
        Object v2 = h2.value;
        if (v2 == null) {
            return null;
        }
        if (NotificationLite.isComplete(v2) || NotificationLite.isError(v2)) {
            return prev.value;
        }
        return v2;
    }

    ReplaySubject$TimedNode<Object> getHead() {
        long ts2;
        ReplaySubject$TimedNode index = this.head;
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        ReplaySubject$TimedNode next = (ReplaySubject$TimedNode)index.get();
        while (next != null && (ts2 = next.time) <= limit) {
            index = next;
            next = (ReplaySubject$TimedNode)index.get();
        }
        return index;
    }

    @Override
    public T[] getValues(T[] array) {
        ReplaySubject$TimedNode h2 = this.getHead();
        int s2 = this.size(h2);
        if (s2 == 0) {
            if (array.length != 0) {
                array[0] = null;
            }
        } else {
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int i2 = 0; i2 != s2; ++i2) {
                ReplaySubject$TimedNode next = (ReplaySubject$TimedNode)h2.get();
                array[i2] = next.value;
                h2 = next;
            }
            if (array.length > s2) {
                array[s2] = null;
            }
        }
        return array;
    }

    @Override
    public void replay(ReplaySubject$ReplayDisposable<T> rs2) {
        if (rs2.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Observer a2 = rs2.actual;
        ReplaySubject$TimedNode index = (ReplaySubject$TimedNode)rs2.index;
        if (index == null) {
            index = this.getHead();
        }
        while (true) {
            if (rs2.cancelled) {
                rs2.index = null;
                return;
            }
            while (true) {
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                ReplaySubject$TimedNode n2 = (ReplaySubject$TimedNode)index.get();
                if (n2 == null) break;
                Object o2 = n2.value;
                if (this.done && n2.get() == null) {
                    if (NotificationLite.isComplete(o2)) {
                        a2.onComplete();
                    } else {
                        a2.onError(NotificationLite.getError(o2));
                    }
                    rs2.index = null;
                    rs2.cancelled = true;
                    return;
                }
                a2.onNext(o2);
                index = n2;
            }
            if (index.get() != null) continue;
            rs2.index = index;
            if ((missed = rs2.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public int size() {
        return this.size(this.getHead());
    }

    int size(ReplaySubject$TimedNode<Object> h2) {
        int s2;
        for (s2 = 0; s2 != Integer.MAX_VALUE; ++s2) {
            ReplaySubject$TimedNode next = (ReplaySubject$TimedNode)h2.get();
            if (next == null) {
                Object o2 = h2.value;
                if (!NotificationLite.isComplete(o2) && !NotificationLite.isError(o2)) break;
                --s2;
                break;
            }
            h2 = next;
        }
        return s2;
    }
}

