/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.PublishSubject$PublishDisposable;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishSubject<T>
extends Subject<T> {
    static final PublishSubject$PublishDisposable[] TERMINATED = new PublishSubject$PublishDisposable[0];
    static final PublishSubject$PublishDisposable[] EMPTY = new PublishSubject$PublishDisposable[0];
    final AtomicReference<PublishSubject$PublishDisposable<T>[]> subscribers = new AtomicReference<PublishSubject$PublishDisposable[]>(EMPTY);
    Throwable error;

    @CheckReturnValue
    public static <T> PublishSubject<T> create() {
        return new PublishSubject<T>();
    }

    PublishSubject() {
    }

    @Override
    public void subscribeActual(Observer<? super T> t2) {
        PublishSubject$PublishDisposable<T> ps2 = new PublishSubject$PublishDisposable<T>(t2, this);
        t2.onSubscribe(ps2);
        if (this.add(ps2)) {
            if (ps2.isDisposed()) {
                this.remove(ps2);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                t2.onError(ex2);
            } else {
                t2.onComplete();
            }
        }
    }

    boolean add(PublishSubject$PublishDisposable<T> ps2) {
        PublishSubject$PublishDisposable[] b2;
        PublishSubject$PublishDisposable<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new PublishSubject$PublishDisposable[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = ps2;
        } while (!this.subscribers.compareAndSet(a2, b2));
        return true;
    }

    void remove(PublishSubject$PublishDisposable<T> ps2) {
        PublishSubject$PublishDisposable[] b2;
        PublishSubject$PublishDisposable<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED || a2 == EMPTY) {
                return;
            }
            int n2 = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != ps2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new PublishSubject$PublishDisposable[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (this.subscribers.get() == TERMINATED) {
            s2.dispose();
        }
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishSubject$PublishDisposable<T> s2 : this.subscribers.get()) {
            s2.onNext(t2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        for (PublishSubject$PublishDisposable s2 : this.subscribers.getAndSet(TERMINATED)) {
            s2.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishSubject$PublishDisposable s2 : this.subscribers.getAndSet(TERMINATED)) {
            s2.onComplete();
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    public Throwable getThrowable() {
        if (this.subscribers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }
}

