/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.CompletableSubject$CompletableDisposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableSubject
extends Completable
implements CompletableObserver {
    final AtomicReference<CompletableSubject$CompletableDisposable[]> observers;
    static final CompletableSubject$CompletableDisposable[] EMPTY = new CompletableSubject$CompletableDisposable[0];
    static final CompletableSubject$CompletableDisposable[] TERMINATED = new CompletableSubject$CompletableDisposable[0];
    final AtomicBoolean once = new AtomicBoolean();
    Throwable error;

    @CheckReturnValue
    public static CompletableSubject create() {
        return new CompletableSubject();
    }

    CompletableSubject() {
        this.observers = new AtomicReference<CompletableSubject$CompletableDisposable[]>(EMPTY);
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (this.observers.get() == TERMINATED) {
            d2.dispose();
        }
    }

    @Override
    public void onError(Throwable e2) {
        ObjectHelper.requireNonNull(e2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.once.compareAndSet(false, true)) {
            this.error = e2;
            for (CompletableSubject$CompletableDisposable md2 : this.observers.getAndSet(TERMINATED)) {
                md2.actual.onError(e2);
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            for (CompletableSubject$CompletableDisposable md2 : this.observers.getAndSet(TERMINATED)) {
                md2.actual.onComplete();
            }
        }
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        CompletableSubject$CompletableDisposable md2 = new CompletableSubject$CompletableDisposable(observer, this);
        observer.onSubscribe(md2);
        if (this.add(md2)) {
            if (md2.isDisposed()) {
                this.remove(md2);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                observer.onError(ex2);
            } else {
                observer.onComplete();
            }
        }
    }

    boolean add(CompletableSubject$CompletableDisposable inner) {
        CompletableSubject$CompletableDisposable[] b2;
        CompletableSubject$CompletableDisposable[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new CompletableSubject$CompletableDisposable[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = inner;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    void remove(CompletableSubject$CompletableDisposable inner) {
        CompletableSubject$CompletableDisposable[] b2;
        CompletableSubject$CompletableDisposable[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != inner) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new CompletableSubject$CompletableDisposable[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }

    public Throwable getThrowable() {
        if (this.observers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    public boolean hasThrowable() {
        return this.observers.get() == TERMINATED && this.error != null;
    }

    public boolean hasComplete() {
        return this.observers.get() == TERMINATED && this.error == null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }
}

