/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.TestScheduler$TestWorker;
import io.reactivex.schedulers.TestScheduler$TimedRunnable;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class TestScheduler
extends Scheduler {
    final Queue<TestScheduler$TimedRunnable> queue = new PriorityBlockingQueue<TestScheduler$TimedRunnable>(11);
    long counter;
    volatile long time;

    @Override
    public long now(@NonNull TimeUnit unit) {
        return unit.convert(this.time, TimeUnit.NANOSECONDS);
    }

    public void advanceTimeBy(long delayTime, TimeUnit unit) {
        this.advanceTimeTo(this.time + unit.toNanos(delayTime), TimeUnit.NANOSECONDS);
    }

    public void advanceTimeTo(long delayTime, TimeUnit unit) {
        long targetTime = unit.toNanos(delayTime);
        this.triggerActions(targetTime);
    }

    public void triggerActions() {
        this.triggerActions(this.time);
    }

    private void triggerActions(long targetTimeInNanoseconds) {
        TestScheduler$TimedRunnable current;
        while ((current = this.queue.peek()) != null && current.time <= targetTimeInNanoseconds) {
            this.time = current.time == 0L ? this.time : current.time;
            this.queue.remove(current);
            if (current.scheduler.disposed) continue;
            current.run.run();
        }
        this.time = targetTimeInNanoseconds;
    }

    @Override
    @NonNull
    public Scheduler$Worker createWorker() {
        return new TestScheduler$TestWorker(this);
    }
}

