/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.Experimental;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.UnicastProcessor$UnicastQueueSubscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastProcessor<T>
extends FlowableProcessor<T> {
    final SpscLinkedArrayQueue<T> queue;
    final AtomicReference<Runnable> onTerminate;
    final boolean delayError;
    volatile boolean done;
    Throwable error;
    final AtomicReference<Yx<? super T>> actual;
    volatile boolean cancelled;
    final AtomicBoolean once;
    final BasicIntQueueSubscription<T> wip;
    final AtomicLong requested;
    boolean enableOperatorFusion;

    @CheckReturnValue
    public static <T> UnicastProcessor<T> create() {
        return new UnicastProcessor<T>(UnicastProcessor.bufferSize());
    }

    @CheckReturnValue
    public static <T> UnicastProcessor<T> create(int capacityHint) {
        return new UnicastProcessor<T>(capacityHint);
    }

    @CheckReturnValue
    @Experimental
    public static <T> UnicastProcessor<T> create(boolean delayError) {
        return new UnicastProcessor<T>(UnicastProcessor.bufferSize(), null, delayError);
    }

    @CheckReturnValue
    public static <T> UnicastProcessor<T> create(int capacityHint, Runnable onCancelled) {
        ObjectHelper.requireNonNull(onCancelled, "onTerminate");
        return new UnicastProcessor<T>(capacityHint, onCancelled);
    }

    @CheckReturnValue
    @Experimental
    public static <T> UnicastProcessor<T> create(int capacityHint, Runnable onCancelled, boolean delayError) {
        ObjectHelper.requireNonNull(onCancelled, "onTerminate");
        return new UnicastProcessor<T>(capacityHint, onCancelled, delayError);
    }

    UnicastProcessor(int capacityHint) {
        this(capacityHint, null, true);
    }

    UnicastProcessor(int capacityHint, Runnable onTerminate) {
        this(capacityHint, onTerminate, true);
    }

    UnicastProcessor(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        this.onTerminate = new AtomicReference<Runnable>(onTerminate);
        this.delayError = delayError;
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastProcessor$UnicastQueueSubscription(this);
        this.requested = new AtomicLong();
    }

    void doTerminate() {
        Runnable r2 = this.onTerminate.get();
        if (r2 != null && this.onTerminate.compareAndSet(r2, null)) {
            r2.run();
        }
    }

    void drainRegular(Yx<? super T> a2) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        boolean failFast = !this.delayError;
        do {
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; r2 != e2; ++e2) {
                boolean empty;
                boolean d2 = this.done;
                T t2 = q2.poll();
                boolean bl2 = empty = t2 == null;
                if (this.checkTerminated(failFast, d2, empty, a2, q2)) {
                    return;
                }
                if (empty) break;
                a2.onNext(t2);
            }
            if (r2 == e2 && this.checkTerminated(failFast, this.done, q2.isEmpty(), a2, q2)) {
                return;
            }
            if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e2);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void drainFused(Yx<? super T> a2) {
        boolean failFast;
        int missed = 1;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        boolean bl2 = failFast = !this.delayError;
        do {
            if (this.cancelled) {
                q2.clear();
                this.actual.lazySet(null);
                return;
            }
            boolean d2 = this.done;
            if (failFast && d2 && this.error != null) {
                q2.clear();
                this.actual.lazySet(null);
                a2.onError(this.error);
                return;
            }
            a2.onNext(null);
            if (!d2) continue;
            this.actual.lazySet(null);
            Throwable ex2 = this.error;
            if (ex2 != null) {
                a2.onError(ex2);
            } else {
                a2.onComplete();
            }
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx<? super T> a2 = this.actual.get();
        while (true) {
            if (a2 != null) {
                if (this.enableOperatorFusion) {
                    this.drainFused(a2);
                } else {
                    this.drainRegular(a2);
                }
                return;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            a2 = this.actual.get();
        }
    }

    boolean checkTerminated(boolean failFast, boolean d2, boolean empty, Yx<? super T> a2, SpscLinkedArrayQueue<T> q2) {
        if (this.cancelled) {
            q2.clear();
            this.actual.lazySet(null);
            return true;
        }
        if (d2) {
            if (failFast && this.error != null) {
                q2.clear();
                this.actual.lazySet(null);
                a2.onError(this.error);
                return true;
            }
            if (empty) {
                Throwable e2 = this.error;
                this.actual.lazySet(null);
                if (e2 != null) {
                    a2.onError(e2);
                } else {
                    a2.onComplete();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (this.done || this.cancelled) {
            s2.cancel();
        } else {
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done || this.cancelled) {
            return;
        }
        this.queue.offer(t2);
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done || this.cancelled) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            s2.onSubscribe(this.wip);
            this.actual.set(s2);
            if (this.cancelled) {
                this.actual.lazySet(null);
            } else {
                this.drain();
            }
        } else {
            EmptySubscription.error(new IllegalStateException("This processor allows only a single Subscriber"), s2);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.actual.get() != null;
    }

    @Override
    public Throwable getThrowable() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    @Override
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }
}

