/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.processors.ReplayProcessor$ReplayBuffer;
import io.reactivex.processors.ReplayProcessor$ReplaySubscription;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

final class ReplayProcessor$UnboundedReplayBuffer<T>
implements ReplayProcessor$ReplayBuffer<T> {
    final List<T> buffer;
    Throwable error;
    volatile boolean done;
    volatile int size;

    ReplayProcessor$UnboundedReplayBuffer(int capacityHint) {
        this.buffer = new ArrayList<T>(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
    }

    @Override
    public void next(T value) {
        this.buffer.add(value);
        ++this.size;
    }

    @Override
    public void error(Throwable ex2) {
        this.error = ex2;
        this.done = true;
    }

    @Override
    public void complete() {
        this.done = true;
    }

    @Override
    public T getValue() {
        int s2 = this.size;
        if (s2 == 0) {
            return null;
        }
        return this.buffer.get(s2 - 1);
    }

    @Override
    public T[] getValues(T[] array) {
        int s2 = this.size;
        if (s2 == 0) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        List<T> b2 = this.buffer;
        if (array.length < s2) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
        }
        for (int i2 = 0; i2 < s2; ++i2) {
            array[i2] = b2.get(i2);
        }
        if (array.length > s2) {
            array[s2] = null;
        }
        return array;
    }

    @Override
    public void replay(ReplayProcessor$ReplaySubscription<T> rs2) {
        int index;
        if (rs2.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        List<T> b2 = this.buffer;
        Yx<T> a2 = rs2.actual;
        Integer indexObject = (Integer)rs2.index;
        if (indexObject != null) {
            index = indexObject;
        } else {
            index = 0;
            rs2.index = 0;
        }
        long e2 = rs2.emitted;
        do {
            int s2;
            boolean d2;
            long r2 = rs2.requested.get();
            while (e2 != r2) {
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                d2 = this.done;
                s2 = this.size;
                if (d2 && index == s2) {
                    rs2.index = null;
                    rs2.cancelled = true;
                    Throwable ex2 = this.error;
                    if (ex2 == null) {
                        a2.onComplete();
                    } else {
                        a2.onError(ex2);
                    }
                    return;
                }
                if (index == s2) break;
                a2.onNext(b2.get(index));
                ++index;
                ++e2;
            }
            if (e2 == r2) {
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                d2 = this.done;
                s2 = this.size;
                if (d2 && index == s2) {
                    rs2.index = null;
                    rs2.cancelled = true;
                    Throwable ex3 = this.error;
                    if (ex3 == null) {
                        a2.onComplete();
                    } else {
                        a2.onError(ex3);
                    }
                    return;
                }
            }
            rs2.index = index;
            rs2.emitted = e2;
        } while ((missed = rs2.addAndGet(-missed)) != 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }
}

