/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.processors.ReplayProcessor$Node;
import io.reactivex.processors.ReplayProcessor$ReplayBuffer;
import io.reactivex.processors.ReplayProcessor$ReplaySubscription;
import java.lang.reflect.Array;

final class ReplayProcessor$SizeBoundReplayBuffer<T>
implements ReplayProcessor$ReplayBuffer<T> {
    final int maxSize;
    int size;
    volatile ReplayProcessor$Node<T> head;
    ReplayProcessor$Node<T> tail;
    Throwable error;
    volatile boolean done;

    ReplayProcessor$SizeBoundReplayBuffer(int maxSize) {
        this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
        ReplayProcessor$Node<Object> h2 = new ReplayProcessor$Node<Object>(null);
        this.tail = h2;
        this.head = h2;
    }

    void trim() {
        if (this.size > this.maxSize) {
            --this.size;
            ReplayProcessor$Node<T> h2 = this.head;
            this.head = (ReplayProcessor$Node)h2.get();
        }
    }

    @Override
    public void next(T value) {
        ReplayProcessor$Node<T> n2 = new ReplayProcessor$Node<T>(value);
        ReplayProcessor$Node<T> t2 = this.tail;
        this.tail = n2;
        ++this.size;
        t2.set(n2);
        this.trim();
    }

    @Override
    public void error(Throwable ex2) {
        this.error = ex2;
        this.done = true;
    }

    @Override
    public void complete() {
        this.done = true;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public T getValue() {
        ReplayProcessor$Node h2 = this.head;
        ReplayProcessor$Node n2;
        while ((n2 = (ReplayProcessor$Node)h2.get()) != null) {
            h2 = n2;
        }
        return h2.value;
    }

    @Override
    public T[] getValues(T[] array) {
        ReplayProcessor$Node next;
        ReplayProcessor$Node h2;
        int s2 = 0;
        ReplayProcessor$Node h0 = h2 = this.head;
        while ((next = (ReplayProcessor$Node)h0.get()) != null) {
            ++s2;
            h0 = next;
        }
        if (array.length < s2) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
        }
        for (int j2 = 0; j2 < s2; ++j2) {
            h2 = (ReplayProcessor$Node)h2.get();
            array[j2] = h2.value;
        }
        if (array.length > s2) {
            array[s2] = null;
        }
        return array;
    }

    @Override
    public void replay(ReplayProcessor$ReplaySubscription<T> rs2) {
        if (rs2.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx a2 = rs2.actual;
        ReplayProcessor$Node index = (ReplayProcessor$Node)rs2.index;
        if (index == null) {
            index = this.head;
        }
        long e2 = rs2.emitted;
        do {
            boolean d2;
            long r2 = rs2.requested.get();
            while (e2 != r2) {
                boolean empty;
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                d2 = this.done;
                ReplayProcessor$Node next = (ReplayProcessor$Node)index.get();
                boolean bl2 = empty = next == null;
                if (d2 && empty) {
                    rs2.index = null;
                    rs2.cancelled = true;
                    Throwable ex2 = this.error;
                    if (ex2 == null) {
                        a2.onComplete();
                    } else {
                        a2.onError(ex2);
                    }
                    return;
                }
                if (empty) break;
                a2.onNext(next.value);
                ++e2;
                index = next;
            }
            if (e2 == r2) {
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                d2 = this.done;
                if (d2 && index.get() == null) {
                    rs2.index = null;
                    rs2.cancelled = true;
                    Throwable ex3 = this.error;
                    if (ex3 == null) {
                        a2.onComplete();
                    } else {
                        a2.onError(ex3);
                    }
                    return;
                }
            }
            rs2.index = index;
            rs2.emitted = e2;
        } while ((missed = rs2.addAndGet(-missed)) != 0);
    }

    @Override
    public int size() {
        ReplayProcessor$Node next;
        int s2;
        ReplayProcessor$Node h2 = this.head;
        for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (ReplayProcessor$Node)h2.get()) != null; ++s2) {
            h2 = next;
        }
        return s2;
    }
}

