/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.Scheduler;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.processors.ReplayProcessor$ReplayBuffer;
import io.reactivex.processors.ReplayProcessor$ReplaySubscription;
import io.reactivex.processors.ReplayProcessor$TimedNode;
import java.lang.reflect.Array;
import java.util.concurrent.TimeUnit;

final class ReplayProcessor$SizeAndTimeBoundReplayBuffer<T>
implements ReplayProcessor$ReplayBuffer<T> {
    final int maxSize;
    final long maxAge;
    final TimeUnit unit;
    final Scheduler scheduler;
    int size;
    volatile ReplayProcessor$TimedNode<T> head;
    ReplayProcessor$TimedNode<T> tail;
    Throwable error;
    volatile boolean done;

    ReplayProcessor$SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
        this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
        this.maxAge = ObjectHelper.verifyPositive(maxAge, "maxAge");
        this.unit = ObjectHelper.requireNonNull(unit, "unit is null");
        this.scheduler = ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ReplayProcessor$TimedNode<Object> h2 = new ReplayProcessor$TimedNode<Object>(null, 0L);
        this.tail = h2;
        this.head = h2;
    }

    void trim() {
        if (this.size > this.maxSize) {
            --this.size;
            ReplayProcessor$TimedNode<T> h2 = this.head;
            this.head = (ReplayProcessor$TimedNode)h2.get();
        }
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        ReplayProcessor$TimedNode h3 = this.head;
        while (true) {
            ReplayProcessor$TimedNode next;
            if ((next = (ReplayProcessor$TimedNode)h3.get()) == null) {
                this.head = h3;
                break;
            }
            if (next.time > limit) {
                this.head = h3;
                break;
            }
            h3 = next;
        }
    }

    void trimFinal() {
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        ReplayProcessor$TimedNode h2 = this.head;
        while (true) {
            ReplayProcessor$TimedNode next;
            if ((next = (ReplayProcessor$TimedNode)h2.get()) == null) {
                this.head = h2;
                break;
            }
            if (next.time > limit) {
                this.head = h2;
                break;
            }
            h2 = next;
        }
    }

    @Override
    public void next(T value) {
        ReplayProcessor$TimedNode<T> n2 = new ReplayProcessor$TimedNode<T>(value, this.scheduler.now(this.unit));
        ReplayProcessor$TimedNode<T> t2 = this.tail;
        this.tail = n2;
        ++this.size;
        t2.set(n2);
        this.trim();
    }

    @Override
    public void error(Throwable ex2) {
        this.trimFinal();
        this.error = ex2;
        this.done = true;
    }

    @Override
    public void complete() {
        this.trimFinal();
        this.done = true;
    }

    @Override
    public T getValue() {
        ReplayProcessor$TimedNode next;
        ReplayProcessor$TimedNode h2 = this.head;
        while ((next = (ReplayProcessor$TimedNode)h2.get()) != null) {
            h2 = next;
        }
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        if (h2.time < limit) {
            return null;
        }
        return h2.value;
    }

    @Override
    public T[] getValues(T[] array) {
        ReplayProcessor$TimedNode h2 = this.getHead();
        int s2 = this.size(h2);
        if (s2 == 0) {
            if (array.length != 0) {
                array[0] = null;
            }
        } else {
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int i2 = 0; i2 != s2; ++i2) {
                ReplayProcessor$TimedNode next = (ReplayProcessor$TimedNode)h2.get();
                array[i2] = next.value;
                h2 = next;
            }
            if (array.length > s2) {
                array[s2] = null;
            }
        }
        return array;
    }

    ReplayProcessor$TimedNode<T> getHead() {
        long ts2;
        ReplayProcessor$TimedNode index = this.head;
        long limit = this.scheduler.now(this.unit) - this.maxAge;
        ReplayProcessor$TimedNode next = (ReplayProcessor$TimedNode)index.get();
        while (next != null && (ts2 = next.time) <= limit) {
            index = next;
            next = (ReplayProcessor$TimedNode)index.get();
        }
        return index;
    }

    @Override
    public void replay(ReplayProcessor$ReplaySubscription<T> rs2) {
        if (rs2.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx a2 = rs2.actual;
        ReplayProcessor$TimedNode index = (ReplayProcessor$TimedNode)rs2.index;
        if (index == null) {
            index = this.getHead();
        }
        long e2 = rs2.emitted;
        do {
            boolean d2;
            long r2 = rs2.requested.get();
            while (e2 != r2) {
                boolean empty;
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                d2 = this.done;
                ReplayProcessor$TimedNode next = (ReplayProcessor$TimedNode)index.get();
                boolean bl2 = empty = next == null;
                if (d2 && empty) {
                    rs2.index = null;
                    rs2.cancelled = true;
                    Throwable ex2 = this.error;
                    if (ex2 == null) {
                        a2.onComplete();
                    } else {
                        a2.onError(ex2);
                    }
                    return;
                }
                if (empty) break;
                a2.onNext(next.value);
                ++e2;
                index = next;
            }
            if (e2 == r2) {
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                d2 = this.done;
                if (d2 && index.get() == null) {
                    rs2.index = null;
                    rs2.cancelled = true;
                    Throwable ex3 = this.error;
                    if (ex3 == null) {
                        a2.onComplete();
                    } else {
                        a2.onError(ex3);
                    }
                    return;
                }
            }
            rs2.index = index;
            rs2.emitted = e2;
        } while ((missed = rs2.addAndGet(-missed)) != 0);
    }

    @Override
    public int size() {
        return this.size(this.getHead());
    }

    int size(ReplayProcessor$TimedNode<T> h2) {
        ReplayProcessor$TimedNode next;
        int s2;
        for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (ReplayProcessor$TimedNode)h2.get()) != null; ++s2) {
            h2 = next;
        }
        return s2;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

