/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.Experimental;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor$PublishSubscription;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishProcessor<T>
extends FlowableProcessor<T> {
    static final PublishProcessor$PublishSubscription[] TERMINATED = new PublishProcessor$PublishSubscription[0];
    static final PublishProcessor$PublishSubscription[] EMPTY = new PublishProcessor$PublishSubscription[0];
    final AtomicReference<PublishProcessor$PublishSubscription<T>[]> subscribers = new AtomicReference<PublishProcessor$PublishSubscription[]>(EMPTY);
    Throwable error;

    @CheckReturnValue
    public static <T> PublishProcessor<T> create() {
        return new PublishProcessor<T>();
    }

    PublishProcessor() {
    }

    @Override
    public void subscribeActual(Yx<? super T> t2) {
        PublishProcessor$PublishSubscription<T> ps2 = new PublishProcessor$PublishSubscription<T>(t2, this);
        t2.onSubscribe(ps2);
        if (this.add(ps2)) {
            if (ps2.isCancelled()) {
                this.remove(ps2);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                t2.onError(ex2);
            } else {
                t2.onComplete();
            }
        }
    }

    boolean add(PublishProcessor$PublishSubscription<T> ps2) {
        PublishProcessor$PublishSubscription[] b2;
        PublishProcessor$PublishSubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new PublishProcessor$PublishSubscription[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = ps2;
        } while (!this.subscribers.compareAndSet(a2, b2));
        return true;
    }

    void remove(PublishProcessor$PublishSubscription<T> ps2) {
        PublishProcessor$PublishSubscription[] b2;
        PublishProcessor$PublishSubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED || a2 == EMPTY) {
                return;
            }
            int n2 = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != ps2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new PublishProcessor$PublishSubscription[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (this.subscribers.get() == TERMINATED) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishProcessor$PublishSubscription<T> s2 : this.subscribers.get()) {
            s2.onNext(t2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        for (PublishProcessor$PublishSubscription s2 : this.subscribers.getAndSet(TERMINATED)) {
            s2.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishProcessor$PublishSubscription s2 : this.subscribers.getAndSet(TERMINATED)) {
            s2.onComplete();
        }
    }

    @Experimental
    public boolean offer(T t2) {
        PublishProcessor$PublishSubscription<T>[] array;
        if (t2 == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return true;
        }
        for (PublishProcessor$PublishSubscription<T> s2 : array = this.subscribers.get()) {
            if (!s2.isFull()) continue;
            return false;
        }
        for (PublishProcessor$PublishSubscription<T> s2 : array) {
            s2.onNext(t2);
        }
        return true;
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    public Throwable getThrowable() {
        if (this.subscribers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }
}

