/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.PublishProcessor;
import java.util.concurrent.atomic.AtomicLong;

final class PublishProcessor$PublishSubscription<T>
extends AtomicLong
implements Yy {
    private static final long serialVersionUID = 3562861878281475070L;
    final Yx<? super T> actual;
    final PublishProcessor<T> parent;

    PublishProcessor$PublishSubscription(Yx<? super T> actual, PublishProcessor<T> parent) {
        this.actual = actual;
        this.parent = parent;
    }

    public void onNext(T t2) {
        long r2 = this.get();
        if (r2 == Long.MIN_VALUE) {
            return;
        }
        if (r2 != 0L) {
            this.actual.onNext(t2);
            BackpressureHelper.producedCancel(this, 1L);
        } else {
            this.cancel();
            this.actual.onError(new MissingBackpressureException("Could not emit value due to lack of requests"));
        }
    }

    public void onError(Throwable t2) {
        if (this.get() != Long.MIN_VALUE) {
            this.actual.onError(t2);
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    public void onComplete() {
        if (this.get() != Long.MIN_VALUE) {
            this.actual.onComplete();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.addCancel(this, n2);
        }
    }

    @Override
    public void cancel() {
        if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
            this.parent.remove(this);
        }
    }

    public boolean isCancelled() {
        return this.get() == Long.MIN_VALUE;
    }

    boolean isFull() {
        return this.get() == 0L;
    }
}

