/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.Experimental;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.BehaviorProcessor$BehaviorSubscription;
import io.reactivex.processors.FlowableProcessor;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BehaviorProcessor<T>
extends FlowableProcessor<T> {
    final AtomicReference<BehaviorProcessor$BehaviorSubscription<T>[]> subscribers;
    static final Object[] EMPTY_ARRAY = new Object[0];
    static final BehaviorProcessor$BehaviorSubscription[] EMPTY = new BehaviorProcessor$BehaviorSubscription[0];
    static final BehaviorProcessor$BehaviorSubscription[] TERMINATED = new BehaviorProcessor$BehaviorSubscription[0];
    final ReadWriteLock lock;
    final Lock readLock;
    final Lock writeLock;
    final AtomicReference<Object> value = new AtomicReference();
    final AtomicReference<Throwable> terminalEvent;
    long index;

    @CheckReturnValue
    public static <T> BehaviorProcessor<T> create() {
        return new BehaviorProcessor<T>();
    }

    @CheckReturnValue
    public static <T> BehaviorProcessor<T> createDefault(T defaultValue) {
        ObjectHelper.requireNonNull(defaultValue, "defaultValue is null");
        return new BehaviorProcessor<T>(defaultValue);
    }

    BehaviorProcessor() {
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        this.subscribers = new AtomicReference<BehaviorProcessor$BehaviorSubscription[]>(EMPTY);
        this.terminalEvent = new AtomicReference();
    }

    BehaviorProcessor(T defaultValue) {
        this();
        this.value.lazySet(ObjectHelper.requireNonNull(defaultValue, "defaultValue is null"));
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        BehaviorProcessor$BehaviorSubscription<T> bs2 = new BehaviorProcessor$BehaviorSubscription<T>(s2, this);
        s2.onSubscribe(bs2);
        if (this.add(bs2)) {
            if (bs2.cancelled) {
                this.remove(bs2);
            } else {
                bs2.emitFirst();
            }
        } else {
            Throwable ex2 = this.terminalEvent.get();
            if (ex2 == ExceptionHelper.TERMINATED) {
                s2.onComplete();
            } else {
                s2.onError(ex2);
            }
        }
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (this.terminalEvent.get() != null) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.terminalEvent.get() != null) {
            return;
        }
        Object o2 = NotificationLite.next(t2);
        this.setCurrent(o2);
        for (BehaviorProcessor$BehaviorSubscription<T> bs2 : this.subscribers.get()) {
            bs2.emitNext(o2, this.index);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (!this.terminalEvent.compareAndSet(null, t2)) {
            RxJavaPlugins.onError(t2);
            return;
        }
        Object o2 = NotificationLite.error(t2);
        for (BehaviorProcessor$BehaviorSubscription<T> bs2 : this.terminate(o2)) {
            bs2.emitNext(o2, this.index);
        }
    }

    @Override
    public void onComplete() {
        if (!this.terminalEvent.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            return;
        }
        Object o2 = NotificationLite.complete();
        for (BehaviorProcessor$BehaviorSubscription<T> bs2 : this.terminate(o2)) {
            bs2.emitNext(o2, this.index);
        }
    }

    @Experimental
    public boolean offer(T t2) {
        BehaviorProcessor$BehaviorSubscription<T>[] array;
        if (t2 == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return true;
        }
        for (BehaviorProcessor$BehaviorSubscription<T> s2 : array = this.subscribers.get()) {
            if (!s2.isFull()) continue;
            return false;
        }
        Object o2 = NotificationLite.next(t2);
        this.setCurrent(o2);
        for (BehaviorProcessor$BehaviorSubscription<T> bs2 : array) {
            bs2.emitNext(o2, this.index);
        }
        return true;
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        Object o2 = this.value.get();
        if (NotificationLite.isError(o2)) {
            return NotificationLite.getError(o2);
        }
        return null;
    }

    public T getValue() {
        Object o2 = this.value.get();
        if (NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) {
            return null;
        }
        return NotificationLite.getValue(o2);
    }

    public Object[] getValues() {
        Object[] a2 = EMPTY_ARRAY;
        Object[] b2 = this.getValues(a2);
        if (b2 == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b2;
    }

    public T[] getValues(T[] array) {
        Object o2 = this.value.get();
        if (o2 == null || NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        Object v2 = NotificationLite.getValue(o2);
        if (array.length != 0) {
            array[0] = v2;
            if (array.length != 1) {
                array[1] = null;
            }
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            array[0] = v2;
        }
        return array;
    }

    @Override
    public boolean hasComplete() {
        Object o2 = this.value.get();
        return NotificationLite.isComplete(o2);
    }

    @Override
    public boolean hasThrowable() {
        Object o2 = this.value.get();
        return NotificationLite.isError(o2);
    }

    public boolean hasValue() {
        Object o2 = this.value.get();
        return o2 != null && !NotificationLite.isComplete(o2) && !NotificationLite.isError(o2);
    }

    boolean add(BehaviorProcessor$BehaviorSubscription<T> rs2) {
        BehaviorProcessor$BehaviorSubscription[] b2;
        BehaviorProcessor$BehaviorSubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a2.length;
            b2 = new BehaviorProcessor$BehaviorSubscription[len + 1];
            System.arraycopy(a2, 0, b2, 0, len);
            b2[len] = rs2;
        } while (!this.subscribers.compareAndSet(a2, b2));
        return true;
    }

    void remove(BehaviorProcessor$BehaviorSubscription<T> rs2) {
        BehaviorProcessor$BehaviorSubscription[] b2;
        BehaviorProcessor$BehaviorSubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED || a2 == EMPTY) {
                return;
            }
            int len = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (a2[i2] != rs2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new BehaviorProcessor$BehaviorSubscription[len - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, len - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    BehaviorProcessor$BehaviorSubscription<T>[] terminate(Object terminalValue) {
        BehaviorProcessor$BehaviorSubscription<T>[] a2 = this.subscribers.get();
        if (a2 != TERMINATED && (a2 = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
            this.setCurrent(terminalValue);
        }
        return a2;
    }

    void setCurrent(Object o2) {
        Lock wl2 = this.writeLock;
        wl2.lock();
        ++this.index;
        this.value.lazySet(o2);
        wl2.unlock();
    }
}

