/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.Observer;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

public final class HalfSerializer {
    private HalfSerializer() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void onNext(Yx<? super T> subscriber, T value, AtomicInteger wip, AtomicThrowable error) {
        if (wip.get() == 0 && wip.compareAndSet(0, 1)) {
            subscriber.onNext(value);
            if (wip.decrementAndGet() != 0) {
                Throwable ex2 = error.terminate();
                if (ex2 != null) {
                    subscriber.onError(ex2);
                } else {
                    subscriber.onComplete();
                }
            }
        }
    }

    public static void onError(Yx<?> subscriber, Throwable ex2, AtomicInteger wip, AtomicThrowable error) {
        if (error.addThrowable(ex2)) {
            if (wip.getAndIncrement() == 0) {
                subscriber.onError(error.terminate());
            }
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    public static void onComplete(Yx<?> subscriber, AtomicInteger wip, AtomicThrowable error) {
        if (wip.getAndIncrement() == 0) {
            Throwable ex2 = error.terminate();
            if (ex2 != null) {
                subscriber.onError(ex2);
            } else {
                subscriber.onComplete();
            }
        }
    }

    public static <T> void onNext(Observer<? super T> observer, T value, AtomicInteger wip, AtomicThrowable error) {
        if (wip.get() == 0 && wip.compareAndSet(0, 1)) {
            observer.onNext(value);
            if (wip.decrementAndGet() != 0) {
                Throwable ex2 = error.terminate();
                if (ex2 != null) {
                    observer.onError(ex2);
                } else {
                    observer.onComplete();
                }
            }
        }
    }

    public static void onError(Observer<?> observer, Throwable ex2, AtomicInteger wip, AtomicThrowable error) {
        if (error.addThrowable(ex2)) {
            if (wip.getAndIncrement() == 0) {
                observer.onError(error.terminate());
            }
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    public static void onComplete(Observer<?> observer, AtomicInteger wip, AtomicThrowable error) {
        if (wip.getAndIncrement() == 0) {
            Throwable ex2 = error.terminate();
            if (ex2 != null) {
                observer.onError(ex2);
            } else {
                observer.onComplete();
            }
        }
    }
}

