/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.Observer;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList$NonThrowingPredicate;
import io.reactivex.internal.util.NotificationLite;

public class AppendOnlyLinkedArrayList<T> {
    final int capacity;
    final Object[] head;
    Object[] tail;
    int offset;

    public AppendOnlyLinkedArrayList(int capacity) {
        this.capacity = capacity;
        this.head = new Object[capacity + 1];
        this.tail = this.head;
    }

    public void add(T value) {
        int o2 = this.offset;
        int c2 = this.capacity;
        if (o2 == c2) {
            Object[] next;
            this.tail[c2] = next = new Object[c2 + 1];
            this.tail = next;
            o2 = 0;
        }
        this.tail[o2] = value;
        this.offset = o2 + 1;
    }

    public void setFirst(T value) {
        this.head[0] = value;
    }

    public void forEachWhile(AppendOnlyLinkedArrayList$NonThrowingPredicate<? super T> consumer) {
        Object[] a2 = this.head;
        int c2 = this.capacity;
        while (a2 != null) {
            Object o2;
            for (int i2 = 0; i2 < c2 && (o2 = a2[i2]) != null && !consumer.test(o2); ++i2) {
            }
            a2 = (Object[])a2[c2];
        }
    }

    public <U> boolean accept(Yx<? super U> subscriber) {
        Object[] a2 = this.head;
        int c2 = this.capacity;
        while (a2 != null) {
            Object o2;
            for (int i2 = 0; i2 < c2 && (o2 = a2[i2]) != null; ++i2) {
                if (!NotificationLite.acceptFull(o2, subscriber)) continue;
                return true;
            }
            a2 = (Object[])a2[c2];
        }
        return false;
    }

    public <U> boolean accept(Observer<? super U> observer) {
        Object[] a2 = this.head;
        int c2 = this.capacity;
        while (a2 != null) {
            Object o2;
            for (int i2 = 0; i2 < c2 && (o2 = a2[i2]) != null; ++i2) {
                if (!NotificationLite.acceptFull(o2, observer)) continue;
                return true;
            }
            a2 = (Object[])a2[c2];
        }
        return false;
    }

    public <S> void forEachWhile(S state, BiPredicate<? super S, ? super T> consumer) {
        Object[] a2 = this.head;
        int c2 = this.capacity;
        while (true) {
            for (int i2 = 0; i2 < c2; ++i2) {
                Object o2 = a2[i2];
                if (o2 == null) {
                    return;
                }
                if (!consumer.test(state, o2)) continue;
                return;
            }
            a2 = (Object[])a2[c2];
        }
    }
}

