/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.exceptions.ProtocolViolationException;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public enum SubscriptionHelper implements Yy
{
    CANCELLED;


    @Override
    public void request(long n2) {
    }

    @Override
    public void cancel() {
    }

    public static boolean validate(Yy current, Yy next) {
        if (next == null) {
            RxJavaPlugins.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return false;
        }
        return true;
    }

    public static void reportSubscriptionSet() {
        RxJavaPlugins.onError(new ProtocolViolationException("Subscription already set!"));
    }

    public static boolean validate(long n2) {
        if (n2 <= 0L) {
            RxJavaPlugins.onError(new IllegalArgumentException("n > 0 required but it was " + n2));
            return false;
        }
        return true;
    }

    public static void reportMoreProduced(long n2) {
        RxJavaPlugins.onError(new ProtocolViolationException("More produced than requested: " + n2));
    }

    public static boolean isCancelled(Yy s2) {
        return s2 == CANCELLED;
    }

    public static boolean set(AtomicReference<Yy> field, Yy s2) {
        Yy current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s2 != null) {
                s2.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s2));
        if (current != null) {
            current.cancel();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Yy> field, Yy s2) {
        ObjectHelper.requireNonNull(s2, "s is null");
        if (!field.compareAndSet(null, s2)) {
            s2.cancel();
            if (field.get() != CANCELLED) {
                SubscriptionHelper.reportSubscriptionSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<Yy> field, Yy s2) {
        Yy current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s2 != null) {
                s2.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s2));
        return true;
    }

    public static boolean cancel(AtomicReference<Yy> field) {
        Yy current = field.get();
        if (current != CANCELLED && (current = field.getAndSet(CANCELLED)) != CANCELLED) {
            if (current != null) {
                current.cancel();
            }
            return true;
        }
        return false;
    }

    public static boolean deferredSetOnce(AtomicReference<Yy> field, AtomicLong requested, Yy s2) {
        if (SubscriptionHelper.setOnce(field, s2)) {
            long r2 = requested.getAndSet(0L);
            if (r2 != 0L) {
                s2.request(r2);
            }
            return true;
        }
        return false;
    }

    public static void deferredRequest(AtomicReference<Yy> field, AtomicLong requested, long n2) {
        Yy s2 = field.get();
        if (s2 != null) {
            s2.request(n2);
        } else if (SubscriptionHelper.validate(n2)) {
            long r2;
            BackpressureHelper.add(requested, n2);
            s2 = field.get();
            if (s2 != null && (r2 = requested.getAndSet(0L)) != 0L) {
                s2.request(r2);
            }
        }
    }
}

