/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class SubscriberResourceWrapper<T>
extends AtomicReference<Disposable>
implements Yy,
FlowableSubscriber<T>,
Disposable {
    private static final long serialVersionUID = -8612022020200669122L;
    final Yx<? super T> actual;
    final AtomicReference<Yy> subscription = new AtomicReference();

    public SubscriberResourceWrapper(Yx<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.subscription, s2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        DisposableHelper.dispose(this);
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            this.subscription.get().request(n2);
        }
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this.subscription);
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.subscription.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public void setResource(Disposable resource) {
        DisposableHelper.set(this, resource);
    }
}

