/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class FutureSubscriber<T>
extends CountDownLatch
implements Yy,
FlowableSubscriber<T>,
Future<T> {
    T value;
    Throwable error;
    final AtomicReference<Yy> s = new AtomicReference();

    public FutureSubscriber() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Yy a2;
        do {
            if ((a2 = this.s.get()) != this && a2 != SubscriptionHelper.CANCELLED) continue;
            return false;
        } while (!this.s.compareAndSet(a2, SubscriptionHelper.CANCELLED));
        if (a2 != null) {
            a2.cancel();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return SubscriptionHelper.isCancelled(this.s.get());
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex2 = this.error;
        if (ex2 != null) {
            throw new ExecutionException(ex2);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            if (!this.await(timeout, unit)) {
                throw new TimeoutException();
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex2 = this.error;
        if (ex2 != null) {
            throw new ExecutionException(ex2);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.s, s2)) {
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.value != null) {
            this.s.get().cancel();
            this.onError(new IndexOutOfBoundsException("More than one element received"));
            return;
        }
        this.value = t2;
    }

    @Override
    public void onError(Throwable t2) {
        Yy a2;
        do {
            if ((a2 = this.s.get()) == this || a2 == SubscriptionHelper.CANCELLED) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.error = t2;
        } while (!this.s.compareAndSet(a2, this));
        this.countDown();
    }

    @Override
    public void onComplete() {
        Yy a2;
        if (this.value == null) {
            this.onError(new NoSuchElementException("The source is empty"));
            return;
        }
        do {
            if ((a2 = this.s.get()) != this && a2 != SubscriptionHelper.CANCELLED) continue;
            return;
        } while (!this.s.compareAndSet(a2, this));
        this.countDown();
    }

    @Override
    public void cancel() {
    }

    @Override
    public void request(long n2) {
    }
}

