/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;

public abstract class BlockingBaseSubscriber<T>
extends CountDownLatch
implements FlowableSubscriber<T> {
    T value;
    Throwable error;
    Yy s;
    volatile boolean cancelled;

    public BlockingBaseSubscriber() {
        super(1);
    }

    @Override
    public final void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            if (!this.cancelled) {
                s2.request(Long.MAX_VALUE);
                if (this.cancelled) {
                    this.s = SubscriptionHelper.CANCELLED;
                    s2.cancel();
                }
            }
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    public final T blockingGet() {
        Throwable e2;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex2) {
                Yy s2 = this.s;
                this.s = SubscriptionHelper.CANCELLED;
                if (s2 != null) {
                    s2.cancel();
                }
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((e2 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e2);
        }
        return this.value;
    }
}

