/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

public abstract class BasicFuseableSubscriber<T, R>
implements FlowableSubscriber<T>,
QueueSubscription<R> {
    protected final Yx<? super R> actual;
    protected Yy s;
    protected QueueSubscription<T> qs;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableSubscriber(Yx<? super R> actual) {
        this.actual = actual;
    }

    @Override
    public final void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueSubscription) {
                this.qs = (QueueSubscription)s2;
            }
            if (this.beforeDownstream()) {
                this.actual.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    protected final void fail(Throwable t2) {
        Exceptions.throwIfFatal(t2);
        this.s.cancel();
        this.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueSubscription<T> qs2 = this.qs;
        if (qs2 != null && (mode & 4) == 0) {
            int m2 = qs2.requestFusion(mode);
            if (m2 != 0) {
                this.sourceMode = m2;
            }
            return m2;
        }
        return 0;
    }

    @Override
    public void request(long n2) {
        this.s.request(n2);
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }

    @Override
    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    @Override
    public void clear() {
        this.qs.clear();
    }

    @Override
    public final boolean offer(R e2) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v1, R v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

