/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.internal.schedulers.TrampolineScheduler$TrampolineWorker;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;

final class TrampolineScheduler$SleepingRunnable
implements Runnable {
    private final Runnable run;
    private final TrampolineScheduler$TrampolineWorker worker;
    private final long execTime;

    TrampolineScheduler$SleepingRunnable(Runnable run, TrampolineScheduler$TrampolineWorker worker, long execTime) {
        this.run = run;
        this.worker = worker;
        this.execTime = execTime;
    }

    @Override
    public void run() {
        if (!this.worker.disposed) {
            long delay;
            long t2 = this.worker.now(TimeUnit.MILLISECONDS);
            if (this.execTime > t2 && (delay = this.execTime - t2) > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    RxJavaPlugins.onError(e2);
                    return;
                }
            }
            if (!this.worker.disposed) {
                this.run.run();
            }
        }
    }
}

