/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.ScheduledRunnable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class SingleScheduler$ScheduledWorker
extends Scheduler$Worker {
    final ScheduledExecutorService executor;
    final CompositeDisposable tasks;
    volatile boolean disposed;

    SingleScheduler$ScheduledWorker(ScheduledExecutorService executor) {
        this.executor = executor;
        this.tasks = new CompositeDisposable();
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ScheduledRunnable sr2 = new ScheduledRunnable(decoratedRun, this.tasks);
        this.tasks.add(sr2);
        try {
            Future<Object> f2 = delay <= 0L ? this.executor.submit(sr2) : this.executor.schedule(sr2, delay, unit);
            sr2.setFuture(f2);
        }
        catch (RejectedExecutionException ex2) {
            this.dispose();
            RxJavaPlugins.onError(ex2);
            return EmptyDisposable.INSTANCE;
        }
        return sr2;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.tasks.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

