/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.Experimental;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.schedulers.SchedulerWhen;
import io.reactivex.internal.schedulers.SchedulerWhen$CreateWorkerFunction;
import io.reactivex.internal.schedulers.SchedulerWhen$QueueWorker;
import io.reactivex.internal.schedulers.SchedulerWhen$SubscribedDisposable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.UnicastProcessor;

@Experimental
public class SchedulerWhen
extends Scheduler
implements Disposable {
    private final Scheduler actualScheduler;
    private final FlowableProcessor<Flowable<Completable>> workerProcessor;
    private Disposable disposable;
    static final Disposable SUBSCRIBED = new SchedulerWhen$SubscribedDisposable();
    static final Disposable DISPOSED = Disposables.disposed();

    public SchedulerWhen(Function<Flowable<Flowable<Completable>>, Completable> combine, Scheduler actualScheduler) {
        this.actualScheduler = actualScheduler;
        this.workerProcessor = UnicastProcessor.create().toSerialized();
        try {
            this.disposable = combine.apply(this.workerProcessor).subscribe();
        }
        catch (Throwable e2) {
            Exceptions.propagate(e2);
        }
    }

    @Override
    public void dispose() {
        this.disposable.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    @Override
    @NonNull
    public Scheduler$Worker createWorker() {
        Scheduler$Worker actualWorker = this.actualScheduler.createWorker();
        FlowableProcessor<ScheduledAction> actionProcessor = UnicastProcessor.create().toSerialized();
        Flowable<Completable> actions = actionProcessor.map(new SchedulerWhen$CreateWorkerFunction(actualWorker));
        SchedulerWhen$QueueWorker worker = new SchedulerWhen$QueueWorker(actionProcessor, actualWorker);
        this.workerProcessor.onNext(actions);
        return worker;
    }
}

