/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableContainer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ScheduledRunnable
extends AtomicReferenceArray<Object>
implements Disposable,
Runnable,
Callable<Object> {
    private static final long serialVersionUID = -6120223772001106981L;
    final Runnable actual;
    static final Object PARENT_DISPOSED = new Object();
    static final Object SYNC_DISPOSED = new Object();
    static final Object ASYNC_DISPOSED = new Object();
    static final Object DONE = new Object();
    static final int PARENT_INDEX = 0;
    static final int FUTURE_INDEX = 1;
    static final int THREAD_INDEX = 2;

    public ScheduledRunnable(Runnable actual, DisposableContainer parent) {
        super(3);
        this.actual = actual;
        this.lazySet(0, parent);
    }

    @Override
    public Object call() {
        this.run();
        return null;
    }

    @Override
    public void run() {
        this.lazySet(2, Thread.currentThread());
        try {
            try {
                this.actual.run();
            }
            catch (Throwable e2) {
                RxJavaPlugins.onError(e2);
            }
        }
        finally {
            this.lazySet(2, null);
            Object o2 = this.get(0);
            if (o2 != PARENT_DISPOSED && this.compareAndSet(0, o2, DONE) && o2 != null) {
                ((DisposableContainer)o2).delete(this);
            }
            while ((o2 = this.get(1)) != SYNC_DISPOSED && o2 != ASYNC_DISPOSED && !this.compareAndSet(1, o2, DONE)) {
            }
        }
    }

    public void setFuture(Future<?> f2) {
        Object o2;
        do {
            if ((o2 = this.get(1)) == DONE) {
                return;
            }
            if (o2 == SYNC_DISPOSED) {
                f2.cancel(false);
                return;
            }
            if (o2 != ASYNC_DISPOSED) continue;
            f2.cancel(true);
            return;
        } while (!this.compareAndSet(1, o2, f2));
    }

    @Override
    public void dispose() {
        Object o2;
        while ((o2 = this.get(1)) != DONE && o2 != SYNC_DISPOSED && o2 != ASYNC_DISPOSED) {
            boolean async = this.get(2) != Thread.currentThread();
            if (!this.compareAndSet(1, o2, async ? ASYNC_DISPOSED : SYNC_DISPOSED)) continue;
            if (o2 == null) break;
            ((Future)o2).cancel(async);
            break;
        }
        do {
            if ((o2 = this.get(0)) != DONE && o2 != PARENT_DISPOSED && o2 != null) continue;
            return;
        } while (!this.compareAndSet(0, o2, PARENT_DISPOSED));
        ((DisposableContainer)o2).delete(this);
    }

    @Override
    public boolean isDisposed() {
        Object o2 = this.get(0);
        return o2 == PARENT_DISPOSED || o2 == DONE;
    }
}

