/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableContainer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.InstantPeriodicTask;
import io.reactivex.internal.schedulers.ScheduledDirectPeriodicTask;
import io.reactivex.internal.schedulers.ScheduledDirectTask;
import io.reactivex.internal.schedulers.ScheduledRunnable;
import io.reactivex.internal.schedulers.SchedulerPoolFactory;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NewThreadWorker
extends Scheduler$Worker
implements Disposable {
    private final ScheduledExecutorService executor;
    volatile boolean disposed;

    public NewThreadWorker(ThreadFactory threadFactory) {
        this.executor = SchedulerPoolFactory.create(threadFactory);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable run) {
        return this.schedule(run, 0L, null);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.scheduleActual(action, delayTime, unit, null);
    }

    public Disposable scheduleDirect(Runnable run, long delayTime, TimeUnit unit) {
        ScheduledDirectTask task = new ScheduledDirectTask(RxJavaPlugins.onSchedule(run));
        try {
            Future<Void> f2 = delayTime <= 0L ? this.executor.submit(task) : this.executor.schedule(task, delayTime, unit);
            task.setFuture(f2);
            return task;
        }
        catch (RejectedExecutionException ex2) {
            RxJavaPlugins.onError(ex2);
            return EmptyDisposable.INSTANCE;
        }
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (period <= 0L) {
            InstantPeriodicTask periodicWrapper = new InstantPeriodicTask(decoratedRun, this.executor);
            try {
                Future<Void> f2 = initialDelay <= 0L ? this.executor.submit(periodicWrapper) : this.executor.schedule(periodicWrapper, initialDelay, unit);
                periodicWrapper.setFirst(f2);
            }
            catch (RejectedExecutionException ex2) {
                RxJavaPlugins.onError(ex2);
                return EmptyDisposable.INSTANCE;
            }
            return periodicWrapper;
        }
        ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun);
        try {
            ScheduledFuture<?> f3 = this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
            task.setFuture(f3);
            return task;
        }
        catch (RejectedExecutionException ex3) {
            RxJavaPlugins.onError(ex3);
            return EmptyDisposable.INSTANCE;
        }
    }

    @NonNull
    public ScheduledRunnable scheduleActual(Runnable run, long delayTime, @NonNull TimeUnit unit, @Nullable DisposableContainer parent) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ScheduledRunnable sr2 = new ScheduledRunnable(decoratedRun, parent);
        if (parent != null && !parent.add(sr2)) {
            return sr2;
        }
        try {
            Future<Object> f2 = delayTime <= 0L ? this.executor.submit(sr2) : this.executor.schedule(sr2, delayTime, unit);
            sr2.setFuture(f2);
        }
        catch (RejectedExecutionException ex2) {
            if (parent != null) {
                parent.remove(sr2);
            }
            RxJavaPlugins.onError(ex2);
        }
        return sr2;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdownNow();
        }
    }

    public void shutdown() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdown();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

