/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.Functions;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

final class InstantPeriodicTask
implements Disposable,
Callable<Void> {
    final Runnable task;
    final AtomicReference<Future<?>> rest;
    final AtomicReference<Future<?>> first;
    final ExecutorService executor;
    Thread runner;
    static final FutureTask<Void> CANCELLED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);

    InstantPeriodicTask(Runnable task, ExecutorService executor) {
        this.task = task;
        this.first = new AtomicReference();
        this.rest = new AtomicReference();
        this.executor = executor;
    }

    @Override
    public Void call() {
        try {
            this.runner = Thread.currentThread();
            try {
                this.task.run();
                this.setRest(this.executor.submit(this));
            }
            catch (Throwable ex2) {
                RxJavaPlugins.onError(ex2);
            }
        }
        finally {
            this.runner = null;
        }
        return null;
    }

    @Override
    public void dispose() {
        Future current = this.first.getAndSet(CANCELLED);
        if (current != null && current != CANCELLED) {
            current.cancel(this.runner != Thread.currentThread());
        }
        if ((current = (Future)this.rest.getAndSet(CANCELLED)) != null && current != CANCELLED) {
            current.cancel(this.runner != Thread.currentThread());
        }
    }

    @Override
    public boolean isDisposed() {
        return this.first.get() == CANCELLED;
    }

    void setFirst(Future<?> f2) {
        Future<?> current;
        do {
            if ((current = this.first.get()) != CANCELLED) continue;
            f2.cancel(this.runner != Thread.currentThread());
        } while (!this.first.compareAndSet(current, f2));
    }

    void setRest(Future<?> f2) {
        Future<?> current;
        do {
            if ((current = this.rest.get()) != CANCELLED) continue;
            f2.cancel(this.runner != Thread.currentThread());
        } while (!this.rest.compareAndSet(current, f2));
    }
}

