/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.schedulers.DisposeOnCancel;
import io.reactivex.internal.schedulers.ExecutorScheduler;
import io.reactivex.internal.schedulers.ExecutorScheduler$ExecutorWorker$BooleanRunnable;
import io.reactivex.internal.schedulers.ExecutorScheduler$ExecutorWorker$SequentialDispose;
import io.reactivex.internal.schedulers.ScheduledRunnable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ExecutorScheduler$ExecutorWorker
extends Scheduler$Worker
implements Runnable {
    final Executor executor;
    final MpscLinkedQueue<Runnable> queue;
    volatile boolean disposed;
    final AtomicInteger wip = new AtomicInteger();
    final CompositeDisposable tasks = new CompositeDisposable();

    public ExecutorScheduler$ExecutorWorker(Executor executor) {
        this.executor = executor;
        this.queue = new MpscLinkedQueue();
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable run) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ExecutorScheduler$ExecutorWorker$BooleanRunnable br2 = new ExecutorScheduler$ExecutorWorker$BooleanRunnable(decoratedRun);
        this.queue.offer(br2);
        if (this.wip.getAndIncrement() == 0) {
            try {
                this.executor.execute(this);
            }
            catch (RejectedExecutionException ex2) {
                this.disposed = true;
                this.queue.clear();
                RxJavaPlugins.onError(ex2);
                return EmptyDisposable.INSTANCE;
            }
        }
        return br2;
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
        if (delay <= 0L) {
            return this.schedule(run);
        }
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        SequentialDisposable first = new SequentialDisposable();
        SequentialDisposable mar = new SequentialDisposable(first);
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ScheduledRunnable sr2 = new ScheduledRunnable(new ExecutorScheduler$ExecutorWorker$SequentialDispose(this, mar, decoratedRun), this.tasks);
        this.tasks.add(sr2);
        if (this.executor instanceof ScheduledExecutorService) {
            try {
                ScheduledFuture<Object> f2 = ((ScheduledExecutorService)this.executor).schedule(sr2, delay, unit);
                sr2.setFuture(f2);
            }
            catch (RejectedExecutionException ex2) {
                this.disposed = true;
                RxJavaPlugins.onError(ex2);
                return EmptyDisposable.INSTANCE;
            }
        } else {
            Disposable d2 = ExecutorScheduler.HELPER.scheduleDirect(sr2, delay, unit);
            sr2.setFuture(new DisposeOnCancel(d2));
        }
        first.replace(sr2);
        return mar;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.tasks.dispose();
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void run() {
        int missed = 1;
        MpscLinkedQueue<Runnable> q2 = this.queue;
        do {
            Runnable run;
            if (this.disposed) {
                q2.clear();
                return;
            }
            while ((run = q2.poll()) != null) {
                run.run();
                if (!this.disposed) continue;
                q2.clear();
                return;
            }
            if (!this.disposed) continue;
            q2.clear();
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }
}

