/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.Functions;
import io.reactivex.schedulers.SchedulerRunnableIntrospection;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractDirectTask
extends AtomicReference<Future<?>>
implements Disposable,
SchedulerRunnableIntrospection {
    private static final long serialVersionUID = 1811839108042568751L;
    protected final Runnable runnable;
    protected Thread runner;
    protected static final FutureTask<Void> FINISHED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);
    protected static final FutureTask<Void> DISPOSED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);

    AbstractDirectTask(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public final void dispose() {
        Future f2 = (Future)this.get();
        if (f2 != FINISHED && f2 != DISPOSED && this.compareAndSet(f2, DISPOSED) && f2 != null) {
            f2.cancel(this.runner != Thread.currentThread());
        }
    }

    @Override
    public final boolean isDisposed() {
        Future f2 = (Future)this.get();
        return f2 == FINISHED || f2 == DISPOSED;
    }

    public final void setFuture(Future<?> future) {
        Future f2;
        while ((f2 = (Future)this.get()) != FINISHED) {
            if (f2 == DISPOSED) {
                future.cancel(this.runner != Thread.currentThread());
                break;
            }
            if (!this.compareAndSet(f2, future)) continue;
            break;
        }
    }

    @Override
    public Runnable getWrappedRunnable() {
        return this.runnable;
    }
}

