/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.single.SingleMap$MapSingleObserver;
import io.reactivex.internal.operators.single.SingleZipArray$SingletonArrayFunc;
import io.reactivex.internal.operators.single.SingleZipArray$ZipCoordinator;

public final class SingleZipArray<T, R>
extends Single<R> {
    final SingleSource<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    public SingleZipArray(SingleSource<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(SingleObserver<? super R> observer) {
        SingleSource<? extends T>[] sources = this.sources;
        int n2 = sources.length;
        if (n2 == 1) {
            sources[0].subscribe(new SingleMap$MapSingleObserver(observer, new SingleZipArray$SingletonArrayFunc(this)));
            return;
        }
        SingleZipArray$ZipCoordinator parent = new SingleZipArray$ZipCoordinator(observer, n2, this.zipper);
        observer.onSubscribe(parent);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (parent.isDisposed()) {
                return;
            }
            SingleSource source = sources[i2];
            if (source == null) {
                parent.innerError(new NullPointerException("One of the sources is null"), i2);
                return;
            }
            source.subscribe(parent.observers[i2]);
        }
    }
}

