/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.single.SingleZipArray$ZipSingleObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class SingleZipArray$ZipCoordinator<T, R>
extends AtomicInteger
implements Disposable {
    private static final long serialVersionUID = -5556924161382950569L;
    final SingleObserver<? super R> actual;
    final Function<? super Object[], ? extends R> zipper;
    final SingleZipArray$ZipSingleObserver<T>[] observers;
    final Object[] values;

    SingleZipArray$ZipCoordinator(SingleObserver<? super R> observer, int n2, Function<? super Object[], ? extends R> zipper) {
        super(n2);
        this.actual = observer;
        this.zipper = zipper;
        SingleZipArray$ZipSingleObserver[] o2 = new SingleZipArray$ZipSingleObserver[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            o2[i2] = new SingleZipArray$ZipSingleObserver(this, i2);
        }
        this.observers = o2;
        this.values = new Object[n2];
    }

    @Override
    public boolean isDisposed() {
        return this.get() <= 0;
    }

    @Override
    public void dispose() {
        if (this.getAndSet(0) > 0) {
            for (SingleZipArray$ZipSingleObserver<T> d2 : this.observers) {
                d2.dispose();
            }
        }
    }

    void innerSuccess(T value, int index) {
        this.values[index] = value;
        if (this.decrementAndGet() == 0) {
            R v2;
            try {
                v2 = ObjectHelper.requireNonNull(this.zipper.apply((Object[])this.values), "The zipper returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.actual.onError(ex2);
                return;
            }
            this.actual.onSuccess(v2);
        }
    }

    void disposeExcept(int index) {
        int i2;
        SingleZipArray$ZipSingleObserver<T>[] observers = this.observers;
        int n2 = observers.length;
        for (i2 = 0; i2 < index; ++i2) {
            observers[i2].dispose();
        }
        for (i2 = index + 1; i2 < n2; ++i2) {
            observers[i2].dispose();
        }
    }

    void innerError(Throwable ex2, int index) {
        if (this.getAndSet(0) > 0) {
            this.disposeExcept(index);
            this.actual.onError(ex2);
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }
}

