/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import java.util.Iterator;

final class SingleFlatMapIterableObservable$FlatMapIterableObserver<T, R>
extends BasicIntQueueDisposable<R>
implements SingleObserver<T> {
    private static final long serialVersionUID = -8938804753851907758L;
    final Observer<? super R> actual;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    Disposable d;
    volatile Iterator<? extends R> it;
    volatile boolean cancelled;
    boolean outputFused;

    SingleFlatMapIterableObservable$FlatMapIterableObserver(Observer<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        boolean has;
        Iterator<R> iterator;
        Observer<R> a2 = this.actual;
        try {
            iterator = this.mapper.apply(value).iterator();
            has = iterator.hasNext();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(ex2);
            return;
        }
        if (!has) {
            a2.onComplete();
            return;
        }
        if (!this.outputFused) {
            boolean b2;
            do {
                R v2;
                if (this.cancelled) {
                    return;
                }
                try {
                    v2 = iterator.next();
                }
                catch (Throwable ex3) {
                    Exceptions.throwIfFatal(ex3);
                    a2.onError(ex3);
                    return;
                }
                a2.onNext(v2);
                if (this.cancelled) {
                    return;
                }
                try {
                    b2 = iterator.hasNext();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    a2.onError(ex4);
                    return;
                }
            } while (b2);
            a2.onComplete();
            return;
        }
        this.it = iterator;
        a2.onNext(null);
        a2.onComplete();
    }

    @Override
    public void onError(Throwable e2) {
        this.d = DisposableHelper.DISPOSED;
        this.actual.onError(e2);
    }

    @Override
    public void dispose() {
        this.cancelled = true;
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    public void clear() {
        this.it = null;
    }

    @Override
    public boolean isEmpty() {
        return this.it == null;
    }

    @Override
    @Nullable
    public R poll() {
        Iterator<R> iterator = this.it;
        if (iterator != null) {
            R v2 = ObjectHelper.requireNonNull(iterator.next(), "The iterator returned a null value");
            if (!iterator.hasNext()) {
                this.it = null;
            }
            return v2;
        }
        return null;
    }
}

