/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.single.SingleFlatMap$SingleFlatMapCallback$FlatMapSingleObserver;
import java.util.concurrent.atomic.AtomicReference;

final class SingleFlatMap$SingleFlatMapCallback<T, R>
extends AtomicReference<Disposable>
implements SingleObserver<T>,
Disposable {
    private static final long serialVersionUID = 3258103020495908596L;
    final SingleObserver<? super R> actual;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;

    SingleFlatMap$SingleFlatMapCallback(SingleObserver<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        SingleSource<R> o2;
        try {
            o2 = ObjectHelper.requireNonNull(this.mapper.apply(value), "The single returned by the mapper is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            return;
        }
        if (!this.isDisposed()) {
            o2.subscribe(new SingleFlatMap$SingleFlatMapCallback$FlatMapSingleObserver<R>(this, this.actual));
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }
}

