/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

final class SingleDoOnSubscribe$DoOnSubscribeSingleObserver<T>
implements SingleObserver<T> {
    final SingleObserver<? super T> actual;
    final Consumer<? super Disposable> onSubscribe;
    boolean done;

    SingleDoOnSubscribe$DoOnSubscribeSingleObserver(SingleObserver<? super T> actual, Consumer<? super Disposable> onSubscribe) {
        this.actual = actual;
        this.onSubscribe = onSubscribe;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        try {
            this.onSubscribe.accept(d2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.done = true;
            d2.dispose();
            EmptyDisposable.error(ex2, this.actual);
            return;
        }
        this.actual.onSubscribe(d2);
    }

    @Override
    public void onSuccess(T value) {
        if (this.done) {
            return;
        }
        this.actual.onSuccess(value);
    }

    @Override
    public void onError(Throwable e2) {
        if (this.done) {
            RxJavaPlugins.onError(e2);
            return;
        }
        this.actual.onError(e2);
    }
}

