/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.single.SingleCache$CacheDisposable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleCache<T>
extends Single<T>
implements SingleObserver<T> {
    static final SingleCache$CacheDisposable[] EMPTY = new SingleCache$CacheDisposable[0];
    static final SingleCache$CacheDisposable[] TERMINATED = new SingleCache$CacheDisposable[0];
    final SingleSource<? extends T> source;
    final AtomicInteger wip;
    final AtomicReference<SingleCache$CacheDisposable<T>[]> observers;
    T value;
    Throwable error;

    public SingleCache(SingleSource<? extends T> source) {
        this.source = source;
        this.wip = new AtomicInteger();
        this.observers = new AtomicReference<SingleCache$CacheDisposable[]>(EMPTY);
    }

    @Override
    public void subscribeActual(SingleObserver<? super T> s2) {
        SingleCache$CacheDisposable<T> d2 = new SingleCache$CacheDisposable<T>(s2, this);
        s2.onSubscribe(d2);
        if (this.add(d2)) {
            if (d2.isDisposed()) {
                this.remove(d2);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                s2.onError(ex2);
            } else {
                s2.onSuccess(this.value);
            }
            return;
        }
        if (this.wip.getAndIncrement() == 0) {
            this.source.subscribe(this);
        }
    }

    boolean add(SingleCache$CacheDisposable<T> observer) {
        SingleCache$CacheDisposable[] b2;
        SingleCache$CacheDisposable<T>[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new SingleCache$CacheDisposable[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = observer;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    void remove(SingleCache$CacheDisposable<T> observer) {
        SingleCache$CacheDisposable[] b2;
        SingleCache$CacheDisposable<T>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != observer) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new SingleCache$CacheDisposable[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }

    @Override
    public void onSubscribe(Disposable d2) {
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        for (SingleCache$CacheDisposable d2 : this.observers.getAndSet(TERMINATED)) {
            if (d2.isDisposed()) continue;
            d2.actual.onSuccess(value);
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.error = e2;
        for (SingleCache$CacheDisposable d2 : this.observers.getAndSet(TERMINATED)) {
            if (d2.isDisposed()) continue;
            d2.actual.onError(e2);
        }
    }
}

