/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.single.SingleAmb$AmbSingleObserver;
import io.reactivex.plugins.RxJavaPlugins;

public final class SingleAmb<T>
extends Single<T> {
    private final SingleSource<? extends T>[] sources;
    private final Iterable<? extends SingleSource<? extends T>> sourcesIterable;

    public SingleAmb(SingleSource<? extends T>[] sources, Iterable<? extends SingleSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(SingleObserver<? super T> s2) {
        SingleSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new SingleSource[8];
            try {
                for (SingleSource<? extends T> singleSource : this.sourcesIterable) {
                    if (singleSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), s2);
                        return;
                    }
                    if (count == sources.length) {
                        SingleSource[] b2 = new SingleSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b2, 0, count);
                        sources = b2;
                    }
                    sources[count++] = singleSource;
                }
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                EmptyDisposable.error(e2, s2);
                return;
            }
        } else {
            count = sources.length;
        }
        CompositeDisposable set = new CompositeDisposable();
        SingleAmb$AmbSingleObserver<T> singleAmb$AmbSingleObserver = new SingleAmb$AmbSingleObserver<T>(s2, set);
        s2.onSubscribe(set);
        for (int i2 = 0; i2 < count; ++i2) {
            SingleSource<T> s1 = sources[i2];
            if (singleAmb$AmbSingleObserver.get()) {
                return;
            }
            if (s1 == null) {
                set.dispose();
                NullPointerException e3 = new NullPointerException("One of the sources is null");
                if (singleAmb$AmbSingleObserver.compareAndSet(false, true)) {
                    s2.onError(e3);
                } else {
                    RxJavaPlugins.onError(e3);
                }
                return;
            }
            s1.subscribe(singleAmb$AmbSingleObserver);
        }
    }
}

