/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.parallel.ParallelRunOn$MultiWorkerCallback;
import io.reactivex.internal.operators.parallel.ParallelRunOn$RunOnConditionalSubscriber;
import io.reactivex.internal.operators.parallel.ParallelRunOn$RunOnSubscriber;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.schedulers.SchedulerMultiWorkerSupport;
import io.reactivex.parallel.ParallelFlowable;

public final class ParallelRunOn<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<? extends T> source;
    final Scheduler scheduler;
    final int prefetch;

    public ParallelRunOn(ParallelFlowable<? extends T> parent, Scheduler scheduler, int prefetch) {
        this.source = parent;
        this.scheduler = scheduler;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Yx<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n2 = subscribers.length;
        Yx[] parents = new Yx[n2];
        if (this.scheduler instanceof SchedulerMultiWorkerSupport) {
            SchedulerMultiWorkerSupport multiworker = (SchedulerMultiWorkerSupport)((Object)this.scheduler);
            multiworker.createWorkers(n2, new ParallelRunOn$MultiWorkerCallback(this, subscribers, parents));
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.createSubscriber(i2, subscribers, parents, this.scheduler.createWorker());
            }
        }
        this.source.subscribe(parents);
    }

    void createSubscriber(int i2, Yx<? super T>[] subscribers, Yx<T>[] parents, Scheduler$Worker worker) {
        Yx<? super T> a2 = subscribers[i2];
        SpscArrayQueue q2 = new SpscArrayQueue(this.prefetch);
        parents[i2] = a2 instanceof ConditionalSubscriber ? new ParallelRunOn$RunOnConditionalSubscriber((ConditionalSubscriber)a2, this.prefetch, q2, worker) : new ParallelRunOn$RunOnSubscriber<T>(a2, this.prefetch, q2, worker);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }
}

