/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.parallel.ParallelReduceFull$ParallelReduceFullInnerSubscriber;
import io.reactivex.internal.operators.parallel.ParallelReduceFull$SlotPair;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ParallelReduceFull$ParallelReduceFullMainSubscriber<T>
extends DeferredScalarSubscription<T> {
    private static final long serialVersionUID = -5370107872170712765L;
    final ParallelReduceFull$ParallelReduceFullInnerSubscriber<T>[] subscribers;
    final BiFunction<T, T, T> reducer;
    final AtomicReference<ParallelReduceFull$SlotPair<T>> current = new AtomicReference();
    final AtomicInteger remaining = new AtomicInteger();
    final AtomicReference<Throwable> error = new AtomicReference();

    ParallelReduceFull$ParallelReduceFullMainSubscriber(Yx<? super T> subscriber, int n2, BiFunction<T, T, T> reducer) {
        super(subscriber);
        ParallelReduceFull$ParallelReduceFullInnerSubscriber[] a2 = new ParallelReduceFull$ParallelReduceFullInnerSubscriber[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            a2[i2] = new ParallelReduceFull$ParallelReduceFullInnerSubscriber<T>(this, reducer);
        }
        this.subscribers = a2;
        this.reducer = reducer;
        this.remaining.lazySet(n2);
    }

    ParallelReduceFull$SlotPair<T> addValue(T value) {
        int c2;
        ParallelReduceFull$SlotPair<T> curr;
        while (true) {
            if ((curr = this.current.get()) == null && !this.current.compareAndSet(null, curr = new ParallelReduceFull$SlotPair())) {
                continue;
            }
            c2 = curr.tryAcquireSlot();
            if (c2 >= 0) break;
            this.current.compareAndSet(curr, null);
        }
        if (c2 == 0) {
            curr.first = value;
        } else {
            curr.second = value;
        }
        if (curr.releaseSlot()) {
            this.current.compareAndSet(curr, null);
            return curr;
        }
        return null;
    }

    @Override
    public void cancel() {
        for (ParallelReduceFull$ParallelReduceFullInnerSubscriber<T> inner : this.subscribers) {
            inner.cancel();
        }
    }

    void innerError(Throwable ex2) {
        if (this.error.compareAndSet(null, ex2)) {
            this.cancel();
            this.actual.onError(ex2);
        } else if (ex2 != this.error.get()) {
            RxJavaPlugins.onError(ex2);
        }
    }

    void innerComplete(T value) {
        ParallelReduceFull$SlotPair<T> sp2;
        if (value != null) {
            while ((sp2 = this.addValue(value)) != null) {
                try {
                    value = ObjectHelper.requireNonNull(this.reducer.apply(sp2.first, sp2.second), "The reducer returned a null value");
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.innerError(ex2);
                    return;
                }
            }
        }
        if (this.remaining.decrementAndGet() == 0) {
            sp2 = this.current.get();
            this.current.lazySet(null);
            if (sp2 != null) {
                this.complete(sp2.first);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

