/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscribers.DeferredScalarSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ParallelReduce$ParallelReduceSubscriber<T, R>
extends DeferredScalarSubscriber<T, R> {
    private static final long serialVersionUID = 8200530050639449080L;
    final BiFunction<R, ? super T, R> reducer;
    R accumulator;
    boolean done;

    ParallelReduce$ParallelReduceSubscriber(Yx<? super R> subscriber, R initialValue, BiFunction<R, ? super T, R> reducer) {
        super(subscriber);
        this.accumulator = initialValue;
        this.reducer = reducer;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.done) {
            R v2;
            try {
                v2 = ObjectHelper.requireNonNull(this.reducer.apply(this.accumulator, t2), "The reducer returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.cancel();
                this.onError(ex2);
                return;
            }
            this.accumulator = v2;
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.accumulator = null;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            R a2 = this.accumulator;
            this.accumulator = null;
            this.complete(a2);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.s.cancel();
    }
}

