/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.parallel.ParallelPeek;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ParallelPeek$ParallelPeekSubscriber<T>
implements Yy,
FlowableSubscriber<T> {
    final Yx<? super T> actual;
    final ParallelPeek<T> parent;
    Yy s;
    boolean done;

    ParallelPeek$ParallelPeekSubscriber(Yx<? super T> actual, ParallelPeek<T> parent) {
        this.actual = actual;
        this.parent = parent;
    }

    @Override
    public void request(long n2) {
        try {
            this.parent.onRequest.accept(n2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
        this.s.request(n2);
    }

    @Override
    public void cancel() {
        try {
            this.parent.onCancel.run();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
        this.s.cancel();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            try {
                this.parent.onSubscribe.accept(s2);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                s2.cancel();
                this.actual.onSubscribe(EmptySubscription.INSTANCE);
                this.onError(ex2);
                return;
            }
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.done) {
            try {
                this.parent.onNext.accept(t2);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.onError(ex2);
                return;
            }
            this.actual.onNext(t2);
            try {
                this.parent.onAfterNext.accept(t2);
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                this.onError(ex3);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        try {
            this.parent.onError.accept(t2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            t2 = new CompositeException(t2, ex2);
        }
        this.actual.onError(t2);
        try {
            this.parent.onAfterTerminated.run();
        }
        catch (Throwable ex3) {
            Exceptions.throwIfFatal(ex3);
            RxJavaPlugins.onError(ex3);
        }
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            try {
                this.parent.onComplete.run();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.actual.onError(ex2);
                return;
            }
            this.actual.onComplete();
            try {
                this.parent.onAfterTerminated.run();
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                RxJavaPlugins.onError(ex3);
            }
        }
    }
}

