/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.parallel.ParallelFailureHandling;
import io.reactivex.plugins.RxJavaPlugins;

final class ParallelMapTry$ParallelMapTryConditionalSubscriber<T, R>
implements Yy,
ConditionalSubscriber<T> {
    final ConditionalSubscriber<? super R> actual;
    final Function<? super T, ? extends R> mapper;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
    Yy s;
    boolean done;

    ParallelMapTry$ParallelMapTryConditionalSubscriber(ConditionalSubscriber<? super R> actual, Function<? super T, ? extends R> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.actual = actual;
        this.mapper = mapper;
        this.errorHandler = errorHandler;
    }

    @Override
    public void request(long n2) {
        this.s.request(n2);
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.tryOnNext(t2) && !this.done) {
            this.s.request(1L);
        }
    }

    @Override
    public boolean tryOnNext(T t2) {
        R v2;
        if (this.done) {
            return false;
        }
        long retries = 0L;
        block9: while (true) {
            try {
                v2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null value");
            }
            catch (Throwable ex2) {
                ParallelFailureHandling h2;
                Exceptions.throwIfFatal(ex2);
                try {
                    h2 = ObjectHelper.requireNonNull(this.errorHandler.apply((Long)(++retries), ex2), "The errorHandler returned a null item");
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    this.cancel();
                    this.onError(new CompositeException(ex2, exc));
                    return false;
                }
                switch (h2) {
                    case RETRY: {
                        continue block9;
                    }
                    case SKIP: {
                        return false;
                    }
                    case STOP: {
                        this.cancel();
                        this.onComplete();
                        return false;
                    }
                }
                this.cancel();
                this.onError(ex2);
                return false;
            }
            break;
        }
        return this.actual.tryOnNext(v2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }
}

