/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.parallel.ParallelFromPublisher$ParallelDispatcher$RailSubscription;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;

final class ParallelFromPublisher$ParallelDispatcher<T>
extends AtomicInteger
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -4470634016609963609L;
    final Yx<? super T>[] subscribers;
    final AtomicLongArray requests;
    final long[] emissions;
    final int prefetch;
    final int limit;
    Yy s;
    SimpleQueue<T> queue;
    Throwable error;
    volatile boolean done;
    int index;
    volatile boolean cancelled;
    final AtomicInteger subscriberCount = new AtomicInteger();
    int produced;
    int sourceMode;

    ParallelFromPublisher$ParallelDispatcher(Yx<? super T>[] subscribers, int prefetch) {
        this.subscribers = subscribers;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
        int m2 = subscribers.length;
        this.requests = new AtomicLongArray(m2 + m2 + 1);
        this.requests.lazySet(m2 + m2, m2);
        this.emissions = new long[m2];
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(7);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.setupSubscribers();
                    this.drain();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    this.setupSubscribers();
                    s2.request(this.prefetch);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.prefetch);
            this.setupSubscribers();
            s2.request(this.prefetch);
        }
    }

    void setupSubscribers() {
        Yx<? super T>[] subs = this.subscribers;
        int m2 = subs.length;
        for (int i2 = 0; i2 < m2; ++i2) {
            if (this.cancelled) {
                return;
            }
            this.subscriberCount.lazySet(i2 + 1);
            subs[i2].onSubscribe(new ParallelFromPublisher$ParallelDispatcher$RailSubscription(this, i2, m2));
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.sourceMode == 0 && !this.queue.offer(t2)) {
            this.s.cancel();
            this.onError(new MissingBackpressureException("Queue is full?"));
            return;
        }
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    void cancel(int m2) {
        if (this.requests.decrementAndGet(m2) == 0L) {
            this.cancelled = true;
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void drainAsync() {
        int missed = 1;
        SimpleQueue<T> q2 = this.queue;
        Yx<? super T>[] a2 = this.subscribers;
        AtomicLongArray r2 = this.requests;
        long[] e2 = this.emissions;
        int n2 = e2.length;
        int idx = this.index;
        int consumed = this.produced;
        while (true) {
            int w2;
            int notReady = 0;
            do {
                long emissionAtIndex;
                Throwable ex2;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                boolean d2 = this.done;
                if (d2 && (ex2 = this.error) != null) {
                    q2.clear();
                    for (Yx<T> yx2 : a2) {
                        yx2.onError(ex2);
                    }
                    return;
                }
                boolean empty = q2.isEmpty();
                if (d2 && empty) {
                    for (Yx<T> yx3 : a2) {
                        yx3.onComplete();
                    }
                    return;
                }
                if (empty) break;
                long requestAtIndex = r2.get(idx);
                if (requestAtIndex != (emissionAtIndex = e2[idx]) && r2.get(n2 + idx) == 0L) {
                    void v2;
                    try {
                        T v22 = q2.poll();
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        this.s.cancel();
                        for (Yx<T> yx4 : a2) {
                            yx4.onError(ex3);
                        }
                        return;
                    }
                    if (v2 == null) break;
                    a2[idx].onNext(v2);
                    e2[idx] = emissionAtIndex + 1L;
                    int c2 = ++consumed;
                    if (c2 == this.limit) {
                        consumed = 0;
                        this.s.request(c2);
                    }
                    notReady = 0;
                } else {
                    ++notReady;
                }
                if (++idx != n2) continue;
                idx = 0;
            } while (notReady != n2);
            if ((w2 = this.get()) == missed) {
                this.index = idx;
                this.produced = consumed;
                if ((missed = this.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w2;
        }
    }

    /*
     * WARNING - void declaration
     */
    void drainSync() {
        int missed = 1;
        SimpleQueue<T> q2 = this.queue;
        Yx<? super T>[] a2 = this.subscribers;
        AtomicLongArray r2 = this.requests;
        long[] e2 = this.emissions;
        int n2 = e2.length;
        int idx = this.index;
        while (true) {
            int notReady = 0;
            do {
                long emissionAtIndex;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                boolean empty = q2.isEmpty();
                if (empty) {
                    for (Yx<T> yx2 : a2) {
                        yx2.onComplete();
                    }
                    return;
                }
                long requestAtIndex = r2.get(idx);
                if (requestAtIndex != (emissionAtIndex = e2[idx]) && r2.get(n2 + idx) == 0L) {
                    void v2;
                    try {
                        T v22 = q2.poll();
                    }
                    catch (Throwable ex2) {
                        void var18_24;
                        Exceptions.throwIfFatal(ex2);
                        this.s.cancel();
                        Yx<? super T>[] yxArray = a2;
                        int n3 = yxArray.length;
                        boolean bl2 = false;
                        while (var18_24 < n3) {
                            Yx<T> yx3 = yxArray[var18_24];
                            yx3.onError(ex2);
                            ++var18_24;
                        }
                        return;
                    }
                    if (v2 == null) {
                        for (Yx<T> yx4 : a2) {
                            yx4.onComplete();
                        }
                        return;
                    }
                    a2[idx].onNext(v2);
                    e2[idx] = emissionAtIndex + 1L;
                    notReady = 0;
                } else {
                    ++notReady;
                }
                if (++idx != n2) continue;
                idx = 0;
            } while (notReady != n2);
            int w2 = this.get();
            if (w2 == missed) {
                this.index = idx;
                if ((missed = this.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w2;
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        if (this.sourceMode == 1) {
            this.drainSync();
        } else {
            this.drainAsync();
        }
    }
}

