/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableZipIterable$ZipIterableObserver;
import java.util.Iterator;

public final class ObservableZipIterable<T, U, V>
extends Observable<V> {
    final Observable<? extends T> source;
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public ObservableZipIterable(Observable<? extends T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.source = source;
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Observer<? super V> t2) {
        boolean b2;
        Iterator<U> it2;
        try {
            it2 = ObjectHelper.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptyDisposable.error(e2, t2);
            return;
        }
        try {
            b2 = it2.hasNext();
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            EmptyDisposable.error(e3, t2);
            return;
        }
        if (!b2) {
            EmptyDisposable.complete(t2);
            return;
        }
        this.source.subscribe(new ObservableZipIterable$ZipIterableObserver<T, U, V>(t2, it2, this.zipper));
    }
}

