/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableWithLatestFrom$WithLatestFromObserver<T, U, R>
extends AtomicReference<U>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -312246233408980075L;
    final Observer<? super R> actual;
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final AtomicReference<Disposable> s = new AtomicReference();
    final AtomicReference<Disposable> other = new AtomicReference();

    ObservableWithLatestFrom$WithLatestFromObserver(Observer<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
        this.actual = actual;
        this.combiner = combiner;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        DisposableHelper.setOnce(this.s, s2);
    }

    @Override
    public void onNext(T t2) {
        Object u2 = this.get();
        if (u2 != null) {
            R r2;
            try {
                r2 = ObjectHelper.requireNonNull(this.combiner.apply(t2, u2), "The combiner returned a null value");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.dispose();
                this.actual.onError(e2);
                return;
            }
            this.actual.onNext(r2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this.other);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        DisposableHelper.dispose(this.other);
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.s);
        DisposableHelper.dispose(this.other);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed(this.s.get());
    }

    public boolean setOther(Disposable o2) {
        return DisposableHelper.setOnce(this.other, o2);
    }

    public void otherError(Throwable e2) {
        DisposableHelper.dispose(this.s);
        this.actual.onError(e2);
    }
}

