/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.ObservableWindowTimed$WindowSkipObserver$CompletionTask;
import io.reactivex.internal.operators.observable.ObservableWindowTimed$WindowSkipObserver$SubjectWork;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.subjects.UnicastSubject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class ObservableWindowTimed$WindowSkipObserver<T>
extends QueueDrainObserver<T, Object, Observable<T>>
implements Disposable,
Runnable {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    final int bufferSize;
    final List<UnicastSubject<T>> windows;
    Disposable s;
    volatile boolean terminated;

    ObservableWindowTimed$WindowSkipObserver(Observer<? super Observable<T>> actual, long timespan, long timeskip, TimeUnit unit, Scheduler$Worker worker, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.worker = worker;
        this.bufferSize = bufferSize;
        this.windows = new LinkedList<UnicastSubject<T>>();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            UnicastSubject w2 = UnicastSubject.create(this.bufferSize);
            this.windows.add(w2);
            this.actual.onNext(w2);
            this.worker.schedule(new ObservableWindowTimed$WindowSkipObserver$CompletionTask(this, w2), this.timespan, this.unit);
            this.worker.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.fastEnter()) {
            for (UnicastSubject<T> w2 : this.windows) {
                w2.onNext(t2);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(t2);
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onError(t2);
        this.disposeWorker();
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onComplete();
        this.disposeWorker();
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void disposeWorker() {
        this.worker.dispose();
    }

    void complete(UnicastSubject<T> w2) {
        this.queue.offer(new ObservableWindowTimed$WindowSkipObserver$SubjectWork<T>(w2, false));
        if (this.enter()) {
            this.drainLoop();
        }
    }

    void drainLoop() {
        MpscLinkedQueue q2 = (MpscLinkedQueue)this.queue;
        Observer a2 = this.actual;
        List<UnicastSubject<T>> ws2 = this.windows;
        int missed = 1;
        block0: while (true) {
            if (this.terminated) {
                this.s.dispose();
                this.disposeWorker();
                q2.clear();
                ws2.clear();
                return;
            }
            boolean d2 = this.done;
            Object v2 = q2.poll();
            boolean empty = v2 == null;
            boolean sw2 = v2 instanceof ObservableWindowTimed$WindowSkipObserver$SubjectWork;
            if (d2 && (empty || sw2)) {
                q2.clear();
                Throwable e2 = this.error;
                if (e2 != null) {
                    for (UnicastSubject<T> w2 : ws2) {
                        w2.onError(e2);
                    }
                } else {
                    for (UnicastSubject<T> w3 : ws2) {
                        w3.onComplete();
                    }
                }
                this.disposeWorker();
                ws2.clear();
                return;
            }
            if (!empty) {
                UnicastSubject w4;
                if (sw2) {
                    ObservableWindowTimed$WindowSkipObserver$SubjectWork work = (ObservableWindowTimed$WindowSkipObserver$SubjectWork)v2;
                    if (work.open) {
                        if (this.cancelled) continue;
                        w4 = UnicastSubject.create(this.bufferSize);
                        ws2.add(w4);
                        a2.onNext(w4);
                        this.worker.schedule(new ObservableWindowTimed$WindowSkipObserver$CompletionTask(this, w4), this.timespan, this.unit);
                        continue;
                    }
                    ws2.remove(work.w);
                    work.w.onComplete();
                    if (!ws2.isEmpty() || !this.cancelled) continue;
                    this.terminated = true;
                    continue;
                }
                Iterator<UnicastSubject<T>> iterator = ws2.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    w4 = iterator.next();
                    w4.onNext(v2);
                }
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    @Override
    public void run() {
        UnicastSubject w2 = UnicastSubject.create(this.bufferSize);
        ObservableWindowTimed$WindowSkipObserver$SubjectWork sw2 = new ObservableWindowTimed$WindowSkipObserver$SubjectWork(w2, true);
        if (!this.cancelled) {
            this.queue.offer(sw2);
        }
        if (this.enter()) {
            this.drainLoop();
        }
    }
}

