/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.ObservableWindowBoundarySelector$OperatorWindowBoundaryCloseObserver;
import io.reactivex.internal.operators.observable.ObservableWindowBoundarySelector$OperatorWindowBoundaryOpenObserver;
import io.reactivex.internal.operators.observable.ObservableWindowBoundarySelector$WindowOperation;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.UnicastSubject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableWindowBoundarySelector$WindowBoundaryMainObserver<T, B, V>
extends QueueDrainObserver<T, Object, Observable<T>>
implements Disposable {
    final ObservableSource<B> open;
    final Function<? super B, ? extends ObservableSource<V>> close;
    final int bufferSize;
    final CompositeDisposable resources;
    Disposable s;
    final AtomicReference<Disposable> boundary = new AtomicReference();
    final List<UnicastSubject<T>> ws;
    final AtomicLong windows = new AtomicLong();

    ObservableWindowBoundarySelector$WindowBoundaryMainObserver(Observer<? super Observable<T>> actual, ObservableSource<B> open, Function<? super B, ? extends ObservableSource<V>> close, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.open = open;
        this.close = close;
        this.bufferSize = bufferSize;
        this.resources = new CompositeDisposable();
        this.ws = new ArrayList<UnicastSubject<T>>();
        this.windows.lazySet(1L);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            ObservableWindowBoundarySelector$OperatorWindowBoundaryOpenObserver os2 = new ObservableWindowBoundarySelector$OperatorWindowBoundaryOpenObserver(this);
            if (this.boundary.compareAndSet(null, os2)) {
                this.windows.getAndIncrement();
                this.open.subscribe(os2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.fastEnter()) {
            for (UnicastSubject<T> w2 : this.ws) {
                w2.onNext(t2);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            this.resources.dispose();
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            this.resources.dispose();
        }
        this.actual.onComplete();
    }

    void error(Throwable t2) {
        this.s.dispose();
        this.resources.dispose();
        this.onError(t2);
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void disposeBoundary() {
        this.resources.dispose();
        DisposableHelper.dispose(this.boundary);
    }

    void drainLoop() {
        MpscLinkedQueue q2 = (MpscLinkedQueue)this.queue;
        Observer a2 = this.actual;
        List<UnicastSubject<T>> ws2 = this.ws;
        int missed = 1;
        block2: while (true) {
            boolean empty;
            boolean d2 = this.done;
            Object o2 = q2.poll();
            boolean bl2 = empty = o2 == null;
            if (d2 && empty) {
                this.disposeBoundary();
                Throwable e2 = this.error;
                if (e2 != null) {
                    for (UnicastSubject<T> w2 : ws2) {
                        w2.onError(e2);
                    }
                } else {
                    for (UnicastSubject<T> w2 : ws2) {
                        w2.onComplete();
                    }
                }
                ws2.clear();
                return;
            }
            if (!empty) {
                UnicastSubject w3;
                if (o2 instanceof ObservableWindowBoundarySelector$WindowOperation) {
                    ObservableSource<V> p2;
                    ObservableWindowBoundarySelector$WindowOperation wo2 = (ObservableWindowBoundarySelector$WindowOperation)o2;
                    w3 = wo2.w;
                    if (w3 != null) {
                        if (!ws2.remove(wo2.w)) continue;
                        wo2.w.onComplete();
                        if (this.windows.decrementAndGet() != 0L) continue;
                        this.disposeBoundary();
                        return;
                    }
                    if (this.cancelled) continue;
                    w3 = UnicastSubject.create(this.bufferSize);
                    ws2.add(w3);
                    a2.onNext(w3);
                    try {
                        p2 = ObjectHelper.requireNonNull(this.close.apply(wo2.open), "The ObservableSource supplied is null");
                    }
                    catch (Throwable e3) {
                        Exceptions.throwIfFatal(e3);
                        this.cancelled = true;
                        a2.onError(e3);
                        continue;
                    }
                    ObservableWindowBoundarySelector$OperatorWindowBoundaryCloseObserver cl2 = new ObservableWindowBoundarySelector$OperatorWindowBoundaryCloseObserver(this, w3);
                    if (!this.resources.add(cl2)) continue;
                    this.windows.getAndIncrement();
                    p2.subscribe(cl2);
                    continue;
                }
                Iterator<UnicastSubject<T>> iterator = ws2.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    w3 = iterator.next();
                    w3.onNext(NotificationLite.getValue(o2));
                }
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    @Override
    public void accept(Observer<? super Observable<T>> a2, Object v2) {
    }

    void open(B b2) {
        this.queue.offer(new ObservableWindowBoundarySelector$WindowOperation(null, b2));
        if (this.enter()) {
            this.drainLoop();
        }
    }

    void close(ObservableWindowBoundarySelector$OperatorWindowBoundaryCloseObserver<T, V> w2) {
        this.resources.delete(w2);
        this.queue.offer(new ObservableWindowBoundarySelector$WindowOperation(w2.w, null));
        if (this.enter()) {
            this.drainLoop();
        }
    }
}

